/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.notifications;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.notifications.UserNotificationDefinition;
import com.liferay.portal.kernel.notifications.UserNotificationFeedEntry;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class UserNotificationManagerUtil {
    private static final Log _log = LogFactoryUtil.getLog(UserNotificationManagerUtil.class);
    private static final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private static final ServiceTrackerMap<String, List<UserNotificationDefinition>> _userNotificationDefinitions = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)_bundleContext, UserNotificationDefinition.class, (String)"javax.portlet.name");
    private static final Map<String, Map<String, UserNotificationHandler>> _userNotificationHandlers = new ConcurrentHashMap<String, Map<String, UserNotificationHandler>>();
    private static final ServiceTracker<UserNotificationHandler, UserNotificationHandler> _userNotificationHandlerServiceTracker = new ServiceTracker(_bundleContext, UserNotificationHandler.class, (ServiceTrackerCustomizer)new UserNotificationHandlerServiceTrackerCustomizer());

    public static UserNotificationDefinition fetchUserNotificationDefinition(String portletId, long classNameId, int notificationType) {
        List userNotificationDefinitions = (List)_userNotificationDefinitions.getService((Object)portletId);
        if (userNotificationDefinitions == null) {
            return null;
        }
        for (UserNotificationDefinition userNotificationDefinition : userNotificationDefinitions) {
            if (userNotificationDefinition.getClassNameId() != classNameId || userNotificationDefinition.getNotificationType() != notificationType) continue;
            return userNotificationDefinition;
        }
        return null;
    }

    public static Map<String, List<UserNotificationDefinition>> getActiveUserNotificationDefinitions() {
        return UserNotificationManagerUtil._getUserNotificationDefinitions(true);
    }

    public static Map<String, List<UserNotificationDefinition>> getUserNotificationDefinitions() {
        return UserNotificationManagerUtil._getUserNotificationDefinitions(false);
    }

    public static Map<String, Map<String, UserNotificationHandler>> getUserNotificationHandlers() {
        return Collections.unmodifiableMap(_userNotificationHandlers);
    }

    public static UserNotificationFeedEntry interpret(String selector, UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws PortalException {
        Map<String, UserNotificationHandler> userNotificationHandlers = _userNotificationHandlers.get(selector);
        if (userNotificationHandlers == null) {
            return null;
        }
        UserNotificationHandler userNotificationHandler = userNotificationHandlers.get(userNotificationEvent.getType());
        if (userNotificationHandler == null) {
            if (_log.isWarnEnabled()) {
                _log.warn("No interpreter found for " + userNotificationEvent);
            }
            return null;
        }
        return userNotificationHandler.interpret(userNotificationEvent, serviceContext);
    }

    public static boolean isDeliver(long userId, String portletId, long classNameId, int notificationType, int deliveryType) throws PortalException {
        return UserNotificationManagerUtil._isDeliver(userId, "", portletId, classNameId, notificationType, deliveryType, null);
    }

    public static boolean isDeliver(long userId, String selector, String portletId, long classNameId, int notificationType, int deliveryType, ServiceContext serviceContext) throws PortalException {
        return UserNotificationManagerUtil._isDeliver(userId, selector, portletId, classNameId, notificationType, deliveryType, serviceContext);
    }

    private static Map<String, List<UserNotificationDefinition>> _getUserNotificationDefinitions(boolean active) {
        ConcurrentHashMap<String, Object> userNotificationDefinitionsMap = new ConcurrentHashMap<String, Object>();
        for (String portletId : _userNotificationDefinitions.keySet()) {
            Portlet portlet;
            if (active && (portlet = PortletLocalServiceUtil.getPortletById(portletId)) == null) continue;
            userNotificationDefinitionsMap.put(portletId, _userNotificationDefinitions.getService((Object)portletId));
        }
        return Collections.unmodifiableMap(userNotificationDefinitionsMap);
    }

    private static boolean _isDeliver(long userId, String selector, String portletId, long classNameId, int notificationType, int deliveryType, ServiceContext serviceContext) throws PortalException {
        Map<String, UserNotificationHandler> userNotificationHandlers = _userNotificationHandlers.get(selector);
        if (userNotificationHandlers == null) {
            return false;
        }
        UserNotificationHandler userNotificationHandler = userNotificationHandlers.get(portletId);
        if (userNotificationHandler == null) {
            return deliveryType == 10000;
        }
        return userNotificationHandler.isDeliver(userId, classNameId, notificationType, deliveryType, serviceContext);
    }

    static {
        _userNotificationHandlerServiceTracker.open();
    }

    private static class UserNotificationHandlerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<UserNotificationHandler, UserNotificationHandler> {
        private UserNotificationHandlerServiceTrackerCustomizer() {
        }

        public UserNotificationHandler addingService(ServiceReference<UserNotificationHandler> serviceReference) {
            UserNotificationHandler userNotificationHandler = (UserNotificationHandler)_bundleContext.getService(serviceReference);
            String selector = userNotificationHandler.getSelector();
            HashMap<String, UserNotificationHandler> userNotificationHandlers = (HashMap<String, UserNotificationHandler>)_userNotificationHandlers.get(selector);
            if (userNotificationHandlers == null) {
                userNotificationHandlers = new HashMap<String, UserNotificationHandler>();
                _userNotificationHandlers.put(selector, userNotificationHandlers);
            }
            userNotificationHandlers.put(userNotificationHandler.getPortletId(), userNotificationHandler);
            return userNotificationHandler;
        }

        public void modifiedService(ServiceReference<UserNotificationHandler> serviceReference, UserNotificationHandler userNotificationHandler) {
        }

        public void removedService(ServiceReference<UserNotificationHandler> serviceReference, UserNotificationHandler userNotificationHandler) {
            _bundleContext.ungetService(serviceReference);
            Map userNotificationHandlers = (Map)_userNotificationHandlers.get(userNotificationHandler.getSelector());
            if (userNotificationHandlers == null) {
                return;
            }
            userNotificationHandlers.remove(userNotificationHandler.getPortletId());
        }
    }
}

