/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class SearchDisplayStyleUtil {
    public static String getDisplayStyle(HttpServletRequest httpServletRequest, String portletName, String defaultValue) {
        return SearchDisplayStyleUtil.getDisplayStyle(httpServletRequest, portletName, "display-style", defaultValue);
    }

    public static String getDisplayStyle(HttpServletRequest httpServletRequest, String portletName, String defaultValue, boolean clearCache) {
        return SearchDisplayStyleUtil.getDisplayStyle(httpServletRequest, portletName, "display-style", defaultValue, clearCache);
    }

    public static String getDisplayStyle(HttpServletRequest httpServletRequest, String portletName, String key, String defaultValue) {
        return SearchDisplayStyleUtil.getDisplayStyle(httpServletRequest, portletName, key, defaultValue, false);
    }

    public static String getDisplayStyle(HttpServletRequest httpServletRequest, String portletName, String key, String defaultValue, boolean clearCache) {
        String displayStyle = ParamUtil.getString(httpServletRequest, "displayStyle");
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences(httpServletRequest);
        if (Validator.isNull(displayStyle)) {
            displayStyle = portalPreferences.getValue(portletName, key, defaultValue);
        } else {
            portalPreferences.setValue(portletName, key, displayStyle);
            if (clearCache) {
                httpServletRequest.setAttribute("LIFERAY_SHARED_SINGLE_PAGE_APPLICATION_CLEAR_CACHE", (Object)Boolean.TRUE);
            }
        }
        return displayStyle;
    }

    public static String getDisplayStyle(PortletRequest portletRequest, String portletName, String defaultValue) {
        return SearchDisplayStyleUtil.getDisplayStyle(PortalUtil.getHttpServletRequest(portletRequest), portletName, defaultValue);
    }

    public static String getDisplayStyle(PortletRequest portletRequest, String portletName, String key, String defaultValue) {
        return SearchDisplayStyleUtil.getDisplayStyle(PortalUtil.getHttpServletRequest(portletRequest), portletName, key, defaultValue);
    }

    public static String getDisplayStyle(PortletRequest portletRequest, String portletName, String key, String defaultValue, boolean clearCache) {
        return SearchDisplayStyleUtil.getDisplayStyle(PortalUtil.getHttpServletRequest(portletRequest), portletName, key, defaultValue, clearCache);
    }
}

