/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet.bridges.mvc;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCCommand;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;

public class MVCCommandCache<T extends MVCCommand> {
    private static final ServiceReferenceMapper<String, MVCCommand> _SERVICE_REFERENCE_MAPPER = (serviceReference, emitter) -> {
        List<String> mvcCommandNames = StringUtil.asList(serviceReference.getProperty("mvc.command.name"));
        for (String mvcCommandName : mvcCommandNames) {
            emitter.emit((Object)mvcCommandName);
        }
    };
    private static final Log _log = LogFactoryUtil.getLog(MVCCommandCache.class);
    private final T _emptyMVCCommand;
    private final String _filterString;
    private final Map<String, T> _mvcCommandCache = new ConcurrentHashMap<String, T>();
    private final Class<T> _mvcCommandClass;
    private final Map<String, List<String>> _mvcCommandKeys = new ConcurrentHashMap<String, List<String>>();
    private final String _mvcCommandPostFix;
    private final Map<String, List<T>> _mvcCommands = new ConcurrentHashMap<String, List<T>>();
    private final String _packagePrefix;
    private final ServiceTrackerMap<String, T> _serviceTrackerMap;

    public MVCCommandCache(T emptyMVCCommand, String packagePrefix, String portletName, Class<T> mvcCommandClass, String mvcCommandPostFix) {
        this(emptyMVCCommand, packagePrefix, portletName, portletName, mvcCommandClass, mvcCommandPostFix);
    }

    public MVCCommandCache(T emptyMVCCommand, String packagePrefix, String portletName, String portletId, Class<T> mvcCommandClass, String mvcCommandPostFix) {
        this._emptyMVCCommand = emptyMVCCommand;
        this._mvcCommandClass = mvcCommandClass;
        this._mvcCommandPostFix = mvcCommandPostFix;
        if (Validator.isNotNull(packagePrefix) && !packagePrefix.endsWith(".")) {
            packagePrefix = packagePrefix + ".";
        }
        this._packagePrefix = packagePrefix;
        this._filterString = portletId.equals(portletName) ? StringBundler.concat((String[])new String[]{"(&(mvc.command.name=*)(javax.portlet.name=", portletId, "))"}) : StringBundler.concat((String[])new String[]{"(&(mvc.command.name=*)(|(javax.portlet.name=", portletName, ")(javax.portlet.name=", portletId, ")))"});
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)SystemBundleUtil.getBundleContext(), this._mvcCommandClass, (String)this._filterString, _SERVICE_REFERENCE_MAPPER);
    }

    public void close() {
        this._serviceTrackerMap.close();
    }

    public T getMVCCommand(String mvcCommandName) {
        MVCCommand mvcCommand = (MVCCommand)this._serviceTrackerMap.getService((Object)mvcCommandName);
        if (mvcCommand != null) {
            return (T)mvcCommand;
        }
        String className = null;
        try {
            mvcCommand = (MVCCommand)this._mvcCommandCache.get(mvcCommandName);
            if (mvcCommand != null) {
                return (T)mvcCommand;
            }
            if (Validator.isNull(this._packagePrefix)) {
                return this._emptyMVCCommand;
            }
            className = StringBundler.concat((Object[])new Object[]{this._packagePrefix, Character.valueOf(Character.toUpperCase(mvcCommandName.charAt(0))), mvcCommandName.substring(1), this._mvcCommandPostFix});
            mvcCommand = (MVCCommand)InstanceFactory.newInstance(className);
            this._mvcCommandCache.put(mvcCommandName, mvcCommand);
            return (T)mvcCommand;
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to instantiate MVCCommand " + className, exception);
            }
            this._mvcCommandCache.put(mvcCommandName, this._emptyMVCCommand);
            return this._emptyMVCCommand;
        }
    }

    public Set<String> getMVCCommandNames() {
        return this._serviceTrackerMap.keySet();
    }

    public List<T> getMVCCommands(String key) {
        List<T> mvcCommands = this._mvcCommands.get(key);
        String[] mvcCommandNames = StringUtil.split(key);
        if (mvcCommands != null && mvcCommands.size() == mvcCommandNames.length) {
            return mvcCommands;
        }
        mvcCommands = new ArrayList<T>();
        for (String mvcCommandName : mvcCommandNames) {
            T mvcCommand = this.getMVCCommand(mvcCommandName);
            if (mvcCommand != this._emptyMVCCommand) {
                mvcCommands.add(mvcCommand);
                continue;
            }
            if (!_log.isWarnEnabled()) continue;
            _log.warn("Unable to find MVCCommand " + key);
        }
        this._mvcCommands.put(key, mvcCommands);
        for (MVCCommand mvcCommand : mvcCommands) {
            String mvcCommandClassName = ClassUtil.getClassName(mvcCommand);
            List<String> keys = this._mvcCommandKeys.get(mvcCommandClassName);
            if (keys == null) {
                keys = new ArrayList<String>();
                this._mvcCommandKeys.put(mvcCommandClassName, keys);
            }
            keys.add(key);
        }
        return mvcCommands;
    }

    public boolean isEmpty() {
        return this._mvcCommandCache.isEmpty();
    }
}

