/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet.bridges.mvc;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.internal.util.ContextResourcePathsUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.portlet.LiferayPortlet;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.bridges.mvc.FormMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCCommandCache;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCHeaderCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.constants.MVCRenderConstants;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.HeaderRequest;
import javax.portlet.HeaderResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;

public class MVCPortlet
extends LiferayPortlet {
    protected String aboutTemplate;
    protected boolean clearRequestParameters;
    protected String configTemplate;
    protected boolean copyRequestParameters;
    protected String editDefaultsTemplate;
    protected String editGuestTemplate;
    protected String editTemplate;
    protected String helpTemplate;
    protected String previewTemplate;
    protected String printTemplate;
    protected String templatePath;
    protected String viewTemplate;
    private static final String _PATH_META_INF_RESOURCES = "/META-INF/resources";
    private static final Log _log = LogFactoryUtil.getLog(MVCPortlet.class);
    private static final Map<String, Map<String, Set<String>>> _validPathsMaps = new ConcurrentHashMap<String, Map<String, Set<String>>>();
    private MVCCommandCache<MVCActionCommand> _actionMVCCommandCache;
    private MVCCommandCache<MVCHeaderCommand> _headerMVCCommandCache;
    private MVCCommandCache<MVCRenderCommand> _renderMVCCommandCache;
    private MVCCommandCache<MVCResourceCommand> _resourceMVCCommandCache;
    private Set<String> _validPaths;

    public void destroy() {
        PortletContext portletContext = this.getPortletContext();
        _validPathsMaps.remove(portletContext.getPortletContextName());
        super.destroy();
        this._actionMVCCommandCache.close();
        this._headerMVCCommandCache.close();
        this._renderMVCCommandCache.close();
        this._resourceMVCCommandCache.close();
    }

    @Override
    public void doAbout(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.aboutTemplate, renderRequest, renderResponse);
    }

    @Override
    public void doConfig(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.configTemplate, renderRequest, renderResponse);
    }

    public void doEdit(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        PortletPreferences portletPreferences = renderRequest.getPreferences();
        if (portletPreferences == null) {
            super.doEdit(renderRequest, renderResponse);
        } else {
            this.include(this.editTemplate, renderRequest, renderResponse);
        }
    }

    @Override
    public void doEditDefaults(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        PortletPreferences portletPreferences = renderRequest.getPreferences();
        if (portletPreferences == null) {
            super.doEdit(renderRequest, renderResponse);
        } else {
            this.include(this.editDefaultsTemplate, renderRequest, renderResponse);
        }
    }

    @Override
    public void doEditGuest(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        PortletPreferences portletPreferences = renderRequest.getPreferences();
        if (portletPreferences == null) {
            super.doEdit(renderRequest, renderResponse);
        } else {
            this.include(this.editGuestTemplate, renderRequest, renderResponse);
        }
    }

    public void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.helpTemplate, renderRequest, renderResponse);
    }

    @Override
    public void doPreview(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.previewTemplate, renderRequest, renderResponse);
    }

    @Override
    public void doPrint(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.printTemplate, renderRequest, renderResponse);
    }

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.viewTemplate, renderRequest, renderResponse);
    }

    @Override
    public void init() throws PortletException {
        super.init();
        this.templatePath = this._getInitParameter("template-path");
        if (Validator.isNull(this.templatePath)) {
            this.templatePath = "/";
        } else {
            if (this.templatePath.contains("\\") || this.templatePath.contains("//") || this.templatePath.contains(".") || this.templatePath.contains(" ")) {
                throw new PortletException("template-path " + this.templatePath + " has invalid characters");
            }
            if (!this.templatePath.startsWith("/") || !this.templatePath.endsWith("/")) {
                throw new PortletException("template-path " + this.templatePath + " must start and end with a /");
            }
        }
        this.aboutTemplate = this._getInitParameter("about-template");
        this.configTemplate = this._getInitParameter("config-template");
        this.editTemplate = this._getInitParameter("edit-template");
        this.editDefaultsTemplate = this._getInitParameter("edit-defaults-template");
        this.editGuestTemplate = this._getInitParameter("edit-guest-template");
        this.helpTemplate = this._getInitParameter("help-template");
        this.previewTemplate = this._getInitParameter("preview-template");
        this.printTemplate = this._getInitParameter("print-template");
        this.viewTemplate = this._getInitParameter("view-template");
        this.clearRequestParameters = GetterUtil.getBoolean(this.getInitParameter("clear-request-parameters"));
        this.copyRequestParameters = GetterUtil.getBoolean(this.getInitParameter("copy-request-parameters"), true);
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)this.getPortletConfig();
        String portletId = liferayPortletConfig.getPortletId();
        this._actionMVCCommandCache = new MVCCommandCache<MVCActionCommand>(MVCActionCommand.EMPTY, this.getInitParameter("mvc-action-command-package-prefix"), this.getPortletName(), portletId, MVCActionCommand.class, "ActionCommand");
        this._headerMVCCommandCache = new MVCCommandCache<MVCHeaderCommand>(MVCHeaderCommand.EMPTY, this.getInitParameter("mvc-header-command-package-prefix"), this.getPortletName(), portletId, MVCHeaderCommand.class, "HeaderCommand");
        this._renderMVCCommandCache = new MVCCommandCache<MVCRenderCommand>(MVCRenderCommand.EMPTY, this.getInitParameter("mvc-render-command-package-prefix"), this.getPortletName(), portletId, MVCRenderCommand.class, "RenderCommand");
        this._resourceMVCCommandCache = new MVCCommandCache<MVCResourceCommand>(MVCResourceCommand.EMPTY, this.getInitParameter("mvc-resource-command-package-prefix"), this.getPortletName(), portletId, MVCResourceCommand.class, "ResourceCommand");
    }

    @Override
    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        super.processAction(actionRequest, actionResponse);
        if (this.copyRequestParameters) {
            PortalUtil.copyRequestParameters(actionRequest, actionResponse);
        }
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.invokeHideDefaultSuccessMessage((PortletRequest)renderRequest);
        String mvcRenderCommandName = ParamUtil.getString((PortletRequest)renderRequest, "mvcRenderCommandName", "/");
        String mvcPath = ParamUtil.getString((PortletRequest)renderRequest, "mvcPath");
        if (!mvcRenderCommandName.equals("/") || Validator.isNull(mvcPath)) {
            MVCRenderCommand mvcRenderCommand = this._renderMVCCommandCache.getMVCCommand(mvcRenderCommandName);
            mvcPath = null;
            if (mvcRenderCommand != MVCRenderCommand.EMPTY) {
                mvcPath = mvcRenderCommand.render(renderRequest, renderResponse);
            }
            if (MVCRenderConstants.MVC_PATH_VALUE_SKIP_DISPATCH.equals(mvcPath)) {
                return;
            }
            if (Validator.isNotNull(mvcPath)) {
                renderRequest.setAttribute(this.getMVCPathAttributeName(renderResponse.getNamespace()), (Object)mvcPath);
            } else if (!mvcRenderCommandName.equals("/") && _log.isWarnEnabled()) {
                _log.warn(StringBundler.concat((Object[])new Object[]{"No render mappings found for MVC render command ", "name \"", HtmlUtil.escape(mvcRenderCommandName), "\" for portlet ", renderRequest.getAttribute("PORTLET_ID")}));
            }
        }
        super.render(renderRequest, renderResponse);
    }

    public void renderHeaders(HeaderRequest headerRequest, HeaderResponse headerResponse) throws IOException, PortletException {
        PortletConfig portletConfig = this.getPortletConfig();
        PortletContext portletContext = portletConfig.getPortletContext();
        if (portletContext.getEffectiveMajorVersion() < 3) {
            return;
        }
        String mvcPath = ParamUtil.getString((PortletRequest)headerRequest, "mvcPath");
        String mvcRenderCommandName = ParamUtil.getString((PortletRequest)headerRequest, "mvcRenderCommandName", "/");
        if (mvcRenderCommandName.equals("/") && Validator.isNotNull(mvcPath)) {
            return;
        }
        MVCHeaderCommand mvcHeaderCommand = this._headerMVCCommandCache.getMVCCommand(mvcRenderCommandName);
        if (mvcHeaderCommand == MVCHeaderCommand.EMPTY) {
            return;
        }
        mvcPath = mvcHeaderCommand.renderHeaders(headerRequest, headerResponse);
        if (Validator.isNotNull(mvcPath) && !MVCRenderConstants.MVC_PATH_VALUE_SKIP_DISPATCH.equals(mvcPath)) {
            headerRequest.setAttribute(this.getMVCPathAttributeName(headerResponse.getNamespace()), (Object)mvcPath);
        }
    }

    @Override
    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        this.invokeHideDefaultSuccessMessage((PortletRequest)resourceRequest);
        String path = this.getPath((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        if (path != null) {
            this.include(path, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse, "RESOURCE_PHASE");
        }
        super.serveResource(resourceRequest, resourceResponse);
    }

    @Override
    protected boolean callActionMethod(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException {
        try {
            this.checkPermissions((PortletRequest)actionRequest);
        }
        catch (Exception exception) {
            throw new PortletException((Throwable)exception);
        }
        Object[] actionNames = ParamUtil.getParameterValues((PortletRequest)actionRequest, "javax.portlet.action");
        String actionName = StringUtil.merge(actionNames);
        if (!actionName.contains(",")) {
            MVCActionCommand mvcActionCommand = this._actionMVCCommandCache.getMVCCommand(actionName);
            if (mvcActionCommand != MVCActionCommand.EMPTY) {
                FormMVCActionCommand formMVCActionCommand;
                if (mvcActionCommand instanceof FormMVCActionCommand && !(formMVCActionCommand = (FormMVCActionCommand)mvcActionCommand).validateForm(actionRequest, actionResponse)) {
                    return false;
                }
                return mvcActionCommand.processAction(actionRequest, actionResponse);
            }
        } else {
            List<MVCActionCommand> mvcActionCommands = this._actionMVCCommandCache.getMVCCommands(actionName);
            if (!mvcActionCommands.isEmpty()) {
                boolean valid = true;
                for (MVCActionCommand mvcActionCommand : mvcActionCommands) {
                    if (!(mvcActionCommand instanceof FormMVCActionCommand)) continue;
                    FormMVCActionCommand formMVCActionCommand = (FormMVCActionCommand)mvcActionCommand;
                    valid &= formMVCActionCommand.validateForm(actionRequest, actionResponse);
                }
                if (!valid) {
                    return false;
                }
                for (MVCActionCommand mvcActionCommand : mvcActionCommands) {
                    if (mvcActionCommand.processAction(actionRequest, actionResponse)) continue;
                    return false;
                }
                return true;
            }
        }
        return super.callActionMethod(actionRequest, actionResponse);
    }

    @Override
    protected boolean callResourceMethod(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException {
        try {
            this.checkPermissions((PortletRequest)resourceRequest);
        }
        catch (Exception exception) {
            throw new PortletException((Throwable)exception);
        }
        String resourceID = GetterUtil.getString(resourceRequest.getResourceID());
        if (!resourceID.contains(",")) {
            MVCResourceCommand mvcResourceCommand = this._resourceMVCCommandCache.getMVCCommand(resourceID);
            if (mvcResourceCommand != MVCResourceCommand.EMPTY) {
                return mvcResourceCommand.serveResource(resourceRequest, resourceResponse);
            }
        } else {
            List<MVCResourceCommand> mvcResourceCommands = this._resourceMVCCommandCache.getMVCCommands(resourceID);
            if (!mvcResourceCommands.isEmpty()) {
                for (MVCResourceCommand mvcResourceCommand : mvcResourceCommands) {
                    if (mvcResourceCommand.serveResource(resourceRequest, resourceResponse)) continue;
                    return false;
                }
                return true;
            }
        }
        return super.callResourceMethod(resourceRequest, resourceResponse);
    }

    protected void checkPermissions(PortletRequest portletRequest) throws Exception {
    }

    @Override
    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        String path = this.getPath((PortletRequest)renderRequest, (PortletResponse)renderResponse);
        if (path != null) {
            WindowState windowState = renderRequest.getWindowState();
            if (windowState.equals((Object)WindowState.MINIMIZED)) {
                return;
            }
            this.include(path, renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected MVCCommandCache<MVCActionCommand> getActionMVCCommandCache() {
        return this._actionMVCCommandCache;
    }

    protected MVCCommandCache<MVCHeaderCommand> getHeaderMVCCommandCache() {
        return this._headerMVCCommandCache;
    }

    protected String getMVCPathAttributeName(String namespace) {
        return StringBundler.concat((String[])new String[]{namespace, ".", MVCRenderConstants.MVC_PATH_REQUEST_ATTRIBUTE_NAME});
    }

    protected String getPath(PortletRequest portletRequest, PortletResponse portletResponse) {
        String mvcPath = portletRequest.getParameter("mvcPath");
        if (mvcPath == null) {
            mvcPath = (String)portletRequest.getAttribute(this.getMVCPathAttributeName(portletResponse.getNamespace()));
        }
        if (mvcPath == null) {
            mvcPath = portletRequest.getParameter("jspPage");
        }
        return mvcPath;
    }

    protected MVCCommandCache<MVCRenderCommand> getRenderMVCCommandCache() {
        return this._renderMVCCommandCache;
    }

    protected MVCCommandCache<MVCResourceCommand> getResourceMVCCommandCache() {
        return this._resourceMVCCommandCache;
    }

    protected void hideDefaultErrorMessage(PortletRequest portletRequest) {
        SessionMessages.add(portletRequest, PortalUtil.getPortletId(portletRequest) + ".hideDefaultErrorMessage");
    }

    protected void hideDefaultSuccessMessage(PortletRequest portletRequest) {
        SessionMessages.add(portletRequest, PortalUtil.getPortletId(portletRequest) + ".hideDefaultSuccessMessage");
    }

    protected void include(String path, ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        this.include(path, (PortletRequest)actionRequest, (PortletResponse)actionResponse, "ACTION_PHASE");
    }

    protected void include(String path, EventRequest eventRequest, EventResponse eventResponse) throws IOException, PortletException {
        this.include(path, (PortletRequest)eventRequest, (PortletResponse)eventResponse, "EVENT_PHASE");
    }

    protected void include(String path, PortletRequest portletRequest, PortletResponse portletResponse, String lifecycle) throws IOException, PortletException {
        PortletRequestDispatcher portletRequestDispatcher;
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest(portletRequest);
        PortletContext portletContext = (PortletContext)httpServletRequest.getAttribute("portlet.context.override." + path);
        if (portletContext == null) {
            portletContext = this.getPortletContext();
        }
        if ((portletRequestDispatcher = portletContext.getRequestDispatcher(path)) == null) {
            _log.error(path + " is not a valid include");
        } else {
            Set<String> validPaths = this._getValidPaths();
            if (Validator.isNotNull(path) && !validPaths.contains(path) && !validPaths.contains(_PATH_META_INF_RESOURCES.concat(path))) {
                throw new PortletException(StringBundler.concat((String[])new String[]{"Path ", path, " is not accessible by portlet ", this.getPortletName()}));
            }
            portletRequestDispatcher.include(portletRequest, portletResponse);
        }
        if (this.clearRequestParameters && lifecycle.equals("RENDER_PHASE")) {
            portletResponse.setProperty("clear-request-parameters", Boolean.TRUE.toString());
        }
    }

    protected void include(String path, RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(path, (PortletRequest)renderRequest, (PortletResponse)renderResponse, "RENDER_PHASE");
    }

    protected void include(String path, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        this.include(path, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse, "RESOURCE_PHASE");
    }

    protected void invokeHideDefaultSuccessMessage(PortletRequest portletRequest) {
        boolean hideDefaultSuccessMessage = ParamUtil.getBoolean(portletRequest, "hideDefaultSuccessMessage");
        if (hideDefaultSuccessMessage) {
            this.hideDefaultSuccessMessage(portletRequest);
        }
    }

    private String _getInitParameter(String name) {
        String value = this.getInitParameter(name);
        if (value != null) {
            return value;
        }
        if (name.equals("template-path")) {
            return this.getInitParameter("jsp-path");
        }
        if (name.endsWith("-template")) {
            name = name.substring(0, name.length() - 9) + "-jsp";
            return this.getInitParameter(name);
        }
        return null;
    }

    private Set<String> _getJspPaths(String path) {
        PortletContext portletContext = this.getPortletContext();
        Set<String> paths = this._visitResources(portletContext, path, "*.jsp");
        if (paths == null) {
            paths = this._visitResources(portletContext, path, "*.jspx");
        } else {
            paths.addAll(this._visitResources(portletContext, path, "*.jspx"));
        }
        if (paths != null) {
            return paths;
        }
        paths = new HashSet<String>();
        ArrayDeque<String> queue = new ArrayDeque<String>();
        queue.add(path);
        while ((path = (String)queue.poll()) != null) {
            Set childPaths = portletContext.getResourcePaths(path);
            if (childPaths == null) continue;
            for (String childPath : childPaths) {
                if (childPath.charAt(childPath.length() - 1) == '/') {
                    queue.add(childPath);
                    continue;
                }
                if (!childPath.endsWith(".jsp") && !childPath.endsWith(".jspx")) continue;
                paths.add(childPath);
            }
        }
        return paths;
    }

    private Set<String> _getValidPaths() {
        if (this._validPaths == null) {
            this._validPaths = this._initValidPaths(this.templatePath);
        }
        return this._validPaths;
    }

    private Set<String> _initValidPaths(String rootPath) {
        PortletApp portletApp;
        PortletContext portletContext = this.getPortletContext();
        String portletContextName = portletContext.getPortletContextName();
        Map validPathsMap = _validPathsMaps.get(portletContextName);
        if (validPathsMap != null) {
            Set<String> validPaths = validPathsMap.get(rootPath);
            if (validPaths != null) {
                return validPaths;
            }
        } else {
            validPathsMap = _validPathsMaps.computeIfAbsent(portletContextName, key -> new ConcurrentHashMap());
        }
        if (rootPath.equals("/") && !(portletApp = PortletLocalServiceUtil.getPortletApp(portletContextName)).isWARFile()) {
            _log.error(StringBundler.concat((String[])new String[]{"Disabling paths for portlet ", this.getPortletName(), " because root path is configured to have access to ", "all portal paths"}));
            return validPathsMap.computeIfAbsent(rootPath, key -> Collections.emptySet());
        }
        return validPathsMap.computeIfAbsent(rootPath, key -> {
            Set<String> validPaths = this._getJspPaths((String)key);
            if (!(key.equals("/") || key.equals("/META-INF/") || key.equals("/META-INF/resources/"))) {
                validPaths.addAll(this._getJspPaths(_PATH_META_INF_RESOURCES.concat((String)key)));
            }
            Collections.addAll(validPaths, StringUtil.split(this.getInitParameter("valid-paths")));
            return validPaths;
        });
    }

    private Set<String> _visitResources(PortletContext portletContext, String path, String pattern) {
        return ContextResourcePathsUtil.visitResources(portletContext, path, pattern, enumeration -> {
            HashSet<String> paths = new HashSet<String>();
            if (enumeration == null) {
                return paths;
            }
            while (enumeration.hasMoreElements()) {
                URL url = (URL)enumeration.nextElement();
                paths.add(url.getPath());
            }
            return paths;
        });
    }
}

