/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet.url.builder;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import javax.portlet.ActionURL;
import javax.portlet.MimeResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.RenderURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public class PortletURLBuilder {
    public static PortletURLStep create(PortletURL portletURL) {
        return new PortletURLStep(portletURL);
    }

    public static PortletURLStep createActionURL(LiferayPortletResponse liferayPortletResponse) {
        return new PortletURLStep((PortletURL)liferayPortletResponse.createActionURL());
    }

    public static PortletURLStep createActionURL(LiferayPortletResponse liferayPortletResponse, MimeResponse.Copy copy) {
        return new PortletURLStep((PortletURL)liferayPortletResponse.createActionURL(copy));
    }

    public static PortletURLStep createActionURL(LiferayPortletResponse liferayPortletResponse, String portletName) {
        return new PortletURLStep(liferayPortletResponse.createActionURL(portletName));
    }

    public static PortletURLStep createActionURL(LiferayPortletResponse liferayPortletResponse, String portletName, MimeResponse.Copy copy) {
        return new PortletURLStep(liferayPortletResponse.createActionURL(portletName, copy));
    }

    public static PortletURLStep createActionURL(MimeResponse mimeResponse) {
        return new PortletURLStep(mimeResponse.createActionURL());
    }

    public static PortletURLStep createActionURL(MimeResponse mimeResponse, MimeResponse.Copy copy) {
        return new PortletURLStep((PortletURL)mimeResponse.createActionURL(copy));
    }

    public static PortletURLStep createLiferayPortletURL(LiferayPortletResponse liferayPortletResponse, long plid, String portletName, String lifecycle) {
        return new PortletURLStep(liferayPortletResponse.createLiferayPortletURL(plid, portletName, lifecycle));
    }

    public static PortletURLStep createLiferayPortletURL(LiferayPortletResponse liferayPortletResponse, long plid, String portletName, String lifecycle, boolean includeLinkToLayoutUuid) {
        return new PortletURLStep(liferayPortletResponse.createLiferayPortletURL(plid, portletName, lifecycle, includeLinkToLayoutUuid));
    }

    public static PortletURLStep createLiferayPortletURL(LiferayPortletResponse liferayPortletResponse, long plid, String portletName, String lifecycle, MimeResponse.Copy copy) {
        return new PortletURLStep(liferayPortletResponse.createLiferayPortletURL(plid, portletName, lifecycle, copy));
    }

    public static PortletURLStep createLiferayPortletURL(LiferayPortletResponse liferayPortletResponse, long plid, String portletName, String lifecycle, MimeResponse.Copy copy, boolean includeLinkToLayoutUuid) {
        return new PortletURLStep(liferayPortletResponse.createLiferayPortletURL(plid, portletName, lifecycle, copy, includeLinkToLayoutUuid));
    }

    public static PortletURLStep createLiferayPortletURL(LiferayPortletResponse liferayPortletResponse, String lifecycle) {
        return new PortletURLStep(liferayPortletResponse.createLiferayPortletURL(lifecycle));
    }

    public static PortletURLStep createLiferayPortletURL(LiferayPortletResponse liferayPortletResponse, String portletName, String lifecycle) {
        return new PortletURLStep(liferayPortletResponse.createLiferayPortletURL(portletName, lifecycle));
    }

    public static PortletURLStep createLiferayPortletURL(LiferayPortletResponse liferayPortletResponse, String portletName, String lifecycle, MimeResponse.Copy copy) {
        return new PortletURLStep(liferayPortletResponse.createLiferayPortletURL(portletName, lifecycle, copy));
    }

    public static PortletURLStep createRenderURL(LiferayPortletResponse liferayPortletResponse) {
        return new PortletURLStep((PortletURL)liferayPortletResponse.createRenderURL());
    }

    public static PortletURLStep createRenderURL(LiferayPortletResponse liferayPortletResponse, MimeResponse.Copy copy) {
        return new PortletURLStep((PortletURL)liferayPortletResponse.createRenderURL(copy));
    }

    public static PortletURLStep createRenderURL(LiferayPortletResponse liferayPortletResponse, String portletName) {
        return new PortletURLStep(liferayPortletResponse.createRenderURL(portletName));
    }

    public static PortletURLStep createRenderURL(LiferayPortletResponse liferayPortletResponse, String portletName, MimeResponse.Copy copy) {
        return new PortletURLStep(liferayPortletResponse.createRenderURL(portletName, copy));
    }

    public static PortletURLStep createRenderURL(MimeResponse mimeResponse) {
        return new PortletURLStep(mimeResponse.createRenderURL());
    }

    public static PortletURLStep createRenderURL(MimeResponse mimeResponse, MimeResponse.Copy copy) {
        return new PortletURLStep((PortletURL)mimeResponse.createRenderURL(copy));
    }

    public static interface WindowStateStep {
        public AfterWindowStateStep setWindowState(WindowState var1);
    }

    @FunctionalInterface
    public static interface UnsafeSupplier<T, E extends Throwable> {
        public T get() throws E;
    }

    public static interface Tabs2Step {
        public AfterTabs2Step setTabs2(String var1);

        public AfterTabs2Step setTabs2(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface Tabs1Step {
        public AfterTabs1Step setTabs1(String var1);

        public AfterTabs1Step setTabs1(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface SecureStep {
        public AfterSecureStep setSecure(boolean var1);
    }

    public static interface RedirectStep {
        public AfterRedirectStep setRedirect(Object var1);

        public AfterRedirectStep setRedirect(String var1);

        public AfterRedirectStep setRedirect(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface PortletResourceStep {
        public AfterPortletResourceStep setPortletResource(String var1);

        public AfterPortletResourceStep setPortletResource(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface PortletModeStep {
        public AfterPortletModeStep setPortletMode(PortletMode var1);
    }

    public static interface ParameterStep {
        public AfterParameterStep setParameter(String var1, Object var2);

        public AfterParameterStep setParameter(String var1, Object var2, boolean var3);

        public AfterParameterStep setParameter(String var1, String var2);

        public AfterParameterStep setParameter(String var1, String ... var2);

        public AfterParameterStep setParameter(String var1, String var2, boolean var3);

        public AfterParameterStep setParameter(String var1, UnsafeSupplier<Object, Exception> var2);

        public AfterParameterStep setParameters(Map<String, String[]> var1);
    }

    public static interface NavigationStep {
        public AfterNavigationStep setNavigation(String var1);

        public AfterNavigationStep setNavigation(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface MVCRenderCommandNameStep {
        public AfterMVCRenderCommandNameStep setMVCRenderCommandName(String var1);

        public AfterMVCRenderCommandNameStep setMVCRenderCommandName(String var1, boolean var2);

        public AfterMVCRenderCommandNameStep setMVCRenderCommandName(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface MVCPathStep {
        public AfterMVCPathStep setMVCPath(String var1);

        public AfterMVCPathStep setMVCPath(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface KeywordsStep {
        public AfterKeywordsStep setKeywords(String var1);

        public AfterKeywordsStep setKeywords(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface GlobalParameterStep {
        public AfterGlobalParameterStep setGlobalParameter(String var1, boolean var2);

        public AfterGlobalParameterStep setGlobalParameter(String var1, double var2);

        public AfterGlobalParameterStep setGlobalParameter(String var1, int var2);

        public AfterGlobalParameterStep setGlobalParameter(String var1, long var2);

        public AfterGlobalParameterStep setGlobalParameter(String var1, short var2);

        public AfterGlobalParameterStep setGlobalParameter(String var1, String var2);

        public AfterGlobalParameterStep setGlobalParameter(String var1, UnsafeSupplier<Object, Exception> var2);
    }

    public static interface CMDStep {
        public AfterCMDStep setCMD(String var1);

        public AfterCMDStep setCMD(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface BuildStep {
        @Deprecated
        public PortletURL build();

        public ActionURL buildActionURL();

        public PortletURL buildPortletURL();

        public RenderURL buildRenderURL();

        public String buildString();
    }

    public static interface BackURLStep {
        public AfterBackURLStep setBackURL(String var1);

        public AfterBackURLStep setBackURL(UnsafeSupplier<Object, Exception> var1);
    }

    public static interface AfterWindowStateStep
    extends BuildStep {
    }

    public static interface AfterTabs2Step
    extends BuildStep,
    GlobalParameterStep,
    ParameterStep,
    PortletModeStep,
    SecureStep,
    WindowStateStep {
    }

    public static interface AfterTabs1Step
    extends BuildStep,
    GlobalParameterStep,
    ParameterStep,
    PortletModeStep,
    SecureStep,
    Tabs2Step,
    WindowStateStep {
    }

    public static interface AfterSecureStep
    extends BuildStep,
    WindowStateStep {
    }

    public static interface AfterRedirectStep
    extends BackURLStep,
    BuildStep,
    GlobalParameterStep,
    KeywordsStep,
    NavigationStep,
    ParameterStep,
    PortletModeStep,
    PortletResourceStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step,
    WindowStateStep {
    }

    public static interface AfterPortletResourceStep
    extends BuildStep,
    GlobalParameterStep,
    ParameterStep,
    PortletModeStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step,
    WindowStateStep {
    }

    public static interface AfterPortletModeStep
    extends BuildStep,
    SecureStep,
    WindowStateStep {
    }

    public static interface AfterParameterStep
    extends BuildStep,
    GlobalParameterStep,
    ParameterStep,
    PortletModeStep,
    SecureStep,
    WindowStateStep {
    }

    public static interface AfterNavigationStep
    extends BuildStep,
    GlobalParameterStep,
    ParameterStep,
    PortletModeStep,
    PortletResourceStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step,
    WindowStateStep {
    }

    public static interface AfterMVCRenderCommandNameStep
    extends BackURLStep,
    BuildStep,
    CMDStep,
    GlobalParameterStep,
    KeywordsStep,
    NavigationStep,
    ParameterStep,
    PortletModeStep,
    PortletResourceStep,
    RedirectStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step,
    WindowStateStep {
    }

    public static interface AfterMVCPathStep
    extends BackURLStep,
    BuildStep,
    CMDStep,
    GlobalParameterStep,
    KeywordsStep,
    MVCRenderCommandNameStep,
    NavigationStep,
    ParameterStep,
    PortletModeStep,
    PortletResourceStep,
    RedirectStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step,
    WindowStateStep {
    }

    public static interface AfterKeywordsStep
    extends BuildStep,
    GlobalParameterStep,
    NavigationStep,
    ParameterStep,
    PortletModeStep,
    PortletResourceStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step,
    WindowStateStep {
    }

    public static interface AfterGlobalParameterStep
    extends BuildStep,
    GlobalParameterStep,
    ParameterStep,
    PortletModeStep,
    SecureStep,
    WindowStateStep {
    }

    public static interface AfterCMDStep
    extends BackURLStep,
    BuildStep,
    GlobalParameterStep,
    KeywordsStep,
    NavigationStep,
    ParameterStep,
    PortletModeStep,
    PortletResourceStep,
    RedirectStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step,
    WindowStateStep {
    }

    public static interface AfterBackURLStep
    extends BuildStep,
    GlobalParameterStep,
    KeywordsStep,
    NavigationStep,
    ParameterStep,
    PortletModeStep,
    PortletResourceStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step,
    WindowStateStep {
    }

    public static interface AfterActionNameStep
    extends BackURLStep,
    BuildStep,
    CMDStep,
    GlobalParameterStep,
    KeywordsStep,
    MVCPathStep,
    MVCRenderCommandNameStep,
    NavigationStep,
    ParameterStep,
    PortletModeStep,
    PortletResourceStep,
    RedirectStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step,
    WindowStateStep {
    }

    public static interface ActionNameStep {
        public AfterActionNameStep setActionName(String var1);

        public AfterActionNameStep setActionName(UnsafeSupplier<Object, Exception> var1);
    }

    public static class PortletURLStep
    implements ActionNameStep,
    AfterActionNameStep,
    AfterBackURLStep,
    AfterCMDStep,
    AfterGlobalParameterStep,
    AfterKeywordsStep,
    AfterMVCPathStep,
    AfterMVCRenderCommandNameStep,
    AfterNavigationStep,
    AfterParameterStep,
    AfterPortletModeStep,
    AfterPortletResourceStep,
    AfterRedirectStep,
    AfterSecureStep,
    AfterTabs1Step,
    AfterTabs2Step,
    AfterWindowStateStep,
    BackURLStep,
    BuildStep,
    CMDStep,
    GlobalParameterStep,
    KeywordsStep,
    MVCPathStep,
    MVCRenderCommandNameStep,
    NavigationStep,
    ParameterStep,
    PortletModeStep,
    PortletResourceStep,
    RedirectStep,
    SecureStep,
    Tabs1Step,
    Tabs2Step,
    WindowStateStep {
        private static final String[][] _RESERVED_KEYWORDS = new String[][]{{"javax.portlet.action", "setActionName"}, {"cmd", "setCMD"}, {"backURL", "setBackURL"}, {"keywords", "setKeywords"}, {"mvcPath", "setMVCPath"}, {"mvcRenderCommandName", "setMVCRenderCommandName"}, {"navigation", "setNavigation"}, {"p_p_mode", "setPortletMode"}, {"p_p_state", "setWindowState"}, {"portletResource", "setPortletResource"}, {"redirect", "setRedirect"}, {"tabs1", "setTabs1"}, {"tabs2", "setTabs2"}};
        private final PortletURL _portletURL;

        public PortletURLStep(PortletURL portletURL) {
            this._portletURL = portletURL;
        }

        @Override
        @Deprecated
        public PortletURL build() {
            return this._portletURL;
        }

        @Override
        public ActionURL buildActionURL() {
            return (ActionURL)this._portletURL;
        }

        @Override
        public PortletURL buildPortletURL() {
            return this._portletURL;
        }

        @Override
        public RenderURL buildRenderURL() {
            return (RenderURL)this._portletURL;
        }

        @Override
        public String buildString() {
            return this._portletURL.toString();
        }

        @Override
        public AfterActionNameStep setActionName(String value) {
            this._setParameter("javax.portlet.action", value, false);
            return this;
        }

        @Override
        public AfterActionNameStep setActionName(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("javax.portlet.action", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterBackURLStep setBackURL(String value) {
            this._setParameter("backURL", value, false);
            return this;
        }

        @Override
        public AfterBackURLStep setBackURL(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("backURL", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterCMDStep setCMD(String value) {
            this._setParameter("cmd", value, false);
            return this;
        }

        @Override
        public AfterCMDStep setCMD(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("cmd", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterGlobalParameterStep setGlobalParameter(String key, boolean value) {
            this.setGlobalParameter(key, String.valueOf(value));
            return this;
        }

        @Override
        public AfterGlobalParameterStep setGlobalParameter(String key, double value) {
            this.setGlobalParameter(key, String.valueOf(value));
            return this;
        }

        @Override
        public AfterGlobalParameterStep setGlobalParameter(String key, int value) {
            this.setGlobalParameter(key, String.valueOf(value));
            return this;
        }

        @Override
        public AfterGlobalParameterStep setGlobalParameter(String key, long value) {
            this.setGlobalParameter(key, String.valueOf(value));
            return this;
        }

        @Override
        public AfterGlobalParameterStep setGlobalParameter(String key, short value) {
            this.setGlobalParameter(key, String.valueOf(value));
            return this;
        }

        @Override
        public AfterGlobalParameterStep setGlobalParameter(String key, String value) {
            this._setParameter(key, URLCodec.encodeURL(value), false);
            return this;
        }

        @Override
        public AfterGlobalParameterStep setGlobalParameter(String key, UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter(key, valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterKeywordsStep setKeywords(String value) {
            this._setParameter("keywords", value, false);
            return this;
        }

        @Override
        public AfterKeywordsStep setKeywords(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("keywords", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterMVCPathStep setMVCPath(String value) {
            this._setParameter("mvcPath", value, false);
            return this;
        }

        @Override
        public AfterMVCPathStep setMVCPath(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("mvcPath", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterMVCRenderCommandNameStep setMVCRenderCommandName(String value) {
            this._setParameter("mvcRenderCommandName", value, false);
            return this;
        }

        @Override
        public AfterMVCRenderCommandNameStep setMVCRenderCommandName(String value, boolean allowNullValue) {
            if (allowNullValue || Validator.isNotNull(value)) {
                this._setParameter("mvcRenderCommandName", value, false);
            }
            return this;
        }

        @Override
        public AfterMVCRenderCommandNameStep setMVCRenderCommandName(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("mvcRenderCommandName", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterNavigationStep setNavigation(String value) {
            this._setParameter("navigation", value, false);
            return this;
        }

        @Override
        public AfterNavigationStep setNavigation(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("navigation", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterParameterStep setParameter(String key, Object value) {
            this._setParameter(key, String.valueOf(value), true);
            return this;
        }

        @Override
        public AfterParameterStep setParameter(String name, Object value, boolean allowNullValue) {
            this.setParameter(name, String.valueOf(value), allowNullValue);
            return this;
        }

        @Override
        public AfterParameterStep setParameter(String key, String value) {
            this._setParameter(key, value, true);
            return this;
        }

        @Override
        public AfterParameterStep setParameter(String key, String ... values) {
            this._portletURL.setParameter(key, values);
            return this;
        }

        @Override
        public AfterParameterStep setParameter(String name, String value, boolean allowNullValue) {
            if (allowNullValue || Validator.isNotNull(value)) {
                this._setParameter(name, value, true);
            }
            return this;
        }

        @Override
        public AfterParameterStep setParameter(String key, UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter(key, valueUnsafeSupplier, true);
            return this;
        }

        @Override
        public AfterParameterStep setParameters(Map<String, String[]> parameters) {
            this._portletURL.setParameters(parameters);
            return this;
        }

        @Override
        public AfterPortletModeStep setPortletMode(PortletMode portletMode) {
            try {
                this._portletURL.setPortletMode(portletMode);
            }
            catch (PortletModeException portletModeException) {
                throw new SystemException(portletModeException);
            }
            return this;
        }

        @Override
        public AfterPortletResourceStep setPortletResource(String value) {
            this._setParameter("portletResource", value, false);
            return this;
        }

        @Override
        public AfterPortletResourceStep setPortletResource(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("portletResource", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterRedirectStep setRedirect(Object value) {
            this._setParameter("redirect", String.valueOf(value), false);
            return this;
        }

        @Override
        public AfterRedirectStep setRedirect(String value) {
            this._setParameter("redirect", value, false);
            return this;
        }

        @Override
        public AfterRedirectStep setRedirect(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("redirect", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterSecureStep setSecure(boolean secure) {
            try {
                this._portletURL.setSecure(secure);
            }
            catch (PortletSecurityException portletSecurityException) {
                throw new SystemException(portletSecurityException);
            }
            return this;
        }

        @Override
        public AfterTabs1Step setTabs1(String value) {
            this._setParameter("tabs1", value, false);
            return this;
        }

        @Override
        public AfterTabs1Step setTabs1(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("tabs1", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterTabs2Step setTabs2(String value) {
            this._setParameter("tabs2", value, false);
            return this;
        }

        @Override
        public AfterTabs2Step setTabs2(UnsafeSupplier<Object, Exception> valueUnsafeSupplier) {
            this._setParameter("tabs2", valueUnsafeSupplier, false);
            return this;
        }

        @Override
        public AfterWindowStateStep setWindowState(WindowState windowState) {
            try {
                this._portletURL.setWindowState(windowState);
            }
            catch (WindowStateException windowStateException) {
                throw new SystemException(windowStateException);
            }
            return this;
        }

        private void _setParameter(String key, String value, boolean validateKey) {
            if (validateKey) {
                this._validateKey(key);
            }
            this._portletURL.setParameter(key, value);
        }

        private void _setParameter(String key, UnsafeSupplier<Object, Exception> valueUnsafeSupplier, boolean validateKey) {
            if (validateKey) {
                this._validateKey(key);
            }
            try {
                Object value = valueUnsafeSupplier.get();
                if (value == null) {
                    return;
                }
                if (value instanceof String[]) {
                    this._portletURL.setParameter(key, (String[])value);
                } else {
                    this._portletURL.setParameter(key, String.valueOf(value));
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        private void _validateKey(String key) {
            if (key == null) {
                return;
            }
            for (String[] reservedKeywordArray : _RESERVED_KEYWORDS) {
                String reservedKey = reservedKeywordArray[0];
                if (!key.equals(reservedKey)) continue;
                throw new RuntimeException(StringBundler.concat((String[])new String[]{"Use method \"", reservedKeywordArray[1], "\" when setting value for \"", reservedKey, "\""}));
            }
        }
    }
}

