/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.resource.bundle;

import com.liferay.petra.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CacheResourceBundleLoader
implements ResourceBundleLoader {
    private static final Log _log = LogFactoryUtil.getLog(CacheResourceBundleLoader.class);
    private static final Set<CacheResourceBundleLoader> _cacheResourceBundleLoaders = Collections.newSetFromMap(new ConcurrentReferenceKeyHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY));
    private static final ResourceBundle _nullResourceBundle = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Object handleGetObject(String key) {
            throw new UnsupportedOperationException();
        }
    };
    private final ResourceBundleLoader _resourceBundleLoader;
    private final Map<Locale, ResourceBundle> _resourceBundles = new ConcurrentHashMap<Locale, ResourceBundle>();

    public static void clearCache() {
        for (CacheResourceBundleLoader cacheResourceBundleLoader : _cacheResourceBundleLoaders) {
            if (cacheResourceBundleLoader == null) continue;
            Map<Locale, ResourceBundle> resourceBundles = cacheResourceBundleLoader._resourceBundles;
            resourceBundles.clear();
        }
    }

    public CacheResourceBundleLoader(ResourceBundleLoader resourceBundleLoader) {
        this._resourceBundleLoader = resourceBundleLoader;
        _cacheResourceBundleLoaders.add(this);
    }

    @Override
    public ResourceBundle loadResourceBundle(Locale locale) {
        ResourceBundle resourceBundle = this._resourceBundles.get(locale);
        if (resourceBundle == _nullResourceBundle) {
            return null;
        }
        if (resourceBundle == null) {
            block6: {
                try {
                    resourceBundle = this._resourceBundleLoader.loadResourceBundle(locale);
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block6;
                    _log.debug(exception);
                }
            }
            if (resourceBundle == null) {
                this._resourceBundles.put(locale, _nullResourceBundle);
            } else {
                this._resourceBundles.put(locale, resourceBundle);
            }
        }
        return resourceBundle;
    }
}

