/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.scheduler;

import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.util.Validator;
import java.util.Date;

public class TriggerConfiguration {
    private String _cronExpression;
    private int _interval;
    private Date _startDate;
    private TimeUnit _timeUnit;

    public static TriggerConfiguration createTriggerConfiguration(int interval, TimeUnit timeUnit) {
        return new TriggerConfiguration(interval, timeUnit);
    }

    public static TriggerConfiguration createTriggerConfiguration(String cronExpression) {
        return new TriggerConfiguration(cronExpression);
    }

    public String getCronExpression() {
        return this._cronExpression;
    }

    public int getInterval() {
        return this._interval;
    }

    public Date getStartDate() {
        return this._startDate;
    }

    public TimeUnit getTimeUnit() {
        return this._timeUnit;
    }

    public void setStartDate(Date startDate) {
        this._startDate = startDate;
    }

    private TriggerConfiguration(int interval, TimeUnit timeUnit) {
        if (interval <= 0) {
            throw new IllegalArgumentException("Interval is either equal or less than 0");
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("Time unit is null");
        }
        this._interval = interval;
        this._timeUnit = timeUnit;
    }

    private TriggerConfiguration(String cronExpression) {
        if (Validator.isNull(cronExpression)) {
            throw new IllegalArgumentException("Cron expression is null or empty");
        }
        this._cronExpression = cronExpression;
    }
}

