/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.suggest.SpellCheckIndexWriter;

public abstract class BaseIndexWriter
implements IndexWriter,
SpellCheckIndexWriter {
    private static final Log _log = LogFactoryUtil.getLog(BaseIndexWriter.class);

    @Override
    public void clearQuerySuggestionDictionaryIndexes(SearchContext searchContext) throws SearchException {
        SpellCheckIndexWriter spellCheckIndexWriter = this.getSpellCheckIndexWriter();
        if (spellCheckIndexWriter == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No spell check index writer configured");
            }
            return;
        }
        spellCheckIndexWriter.clearQuerySuggestionDictionaryIndexes(searchContext);
    }

    @Override
    public void clearSpellCheckerDictionaryIndexes(SearchContext searchContext) throws SearchException {
        SpellCheckIndexWriter spellCheckIndexWriter = this.getSpellCheckIndexWriter();
        if (spellCheckIndexWriter == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No spell check index writer configured");
            }
            return;
        }
        spellCheckIndexWriter.clearSpellCheckerDictionaryIndexes(searchContext);
    }

    @Override
    public void commit(SearchContext searchContext) throws SearchException {
    }

    @Override
    public void indexKeyword(SearchContext searchContext, float weight, String keywordType) throws SearchException {
        SpellCheckIndexWriter spellCheckIndexWriter = this.getSpellCheckIndexWriter();
        if (spellCheckIndexWriter == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No spell check index writer configured");
            }
            return;
        }
        spellCheckIndexWriter.indexKeyword(searchContext, weight, keywordType);
    }

    @Override
    public void indexQuerySuggestionDictionaries(SearchContext searchContext) throws SearchException {
        SpellCheckIndexWriter spellCheckIndexWriter = this.getSpellCheckIndexWriter();
        if (spellCheckIndexWriter == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No spell check index writer configured");
            }
            return;
        }
        spellCheckIndexWriter.indexQuerySuggestionDictionaries(searchContext);
    }

    @Override
    public void indexQuerySuggestionDictionary(SearchContext searchContext) throws SearchException {
        SpellCheckIndexWriter spellCheckIndexWriter = this.getSpellCheckIndexWriter();
        if (spellCheckIndexWriter == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No spell check index writer configured");
            }
            return;
        }
        spellCheckIndexWriter.indexQuerySuggestionDictionary(searchContext);
    }

    @Override
    public void indexSpellCheckerDictionaries(SearchContext searchContext) throws SearchException {
        SpellCheckIndexWriter spellCheckIndexWriter = this.getSpellCheckIndexWriter();
        if (spellCheckIndexWriter == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No spell check index writer configured");
            }
            return;
        }
        spellCheckIndexWriter.indexSpellCheckerDictionaries(searchContext);
    }

    @Override
    public void indexSpellCheckerDictionary(SearchContext searchContext) throws SearchException {
        SpellCheckIndexWriter spellCheckIndexWriter = this.getSpellCheckIndexWriter();
        if (spellCheckIndexWriter == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No spell check index writer configured");
            }
            return;
        }
        spellCheckIndexWriter.indexSpellCheckerDictionary(searchContext);
    }

    protected abstract SpellCheckIndexWriter getSpellCheckIndexWriter();
}

