/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

public abstract class BaseSearcher
extends BaseIndexer<Object> {
    @Override
    public String getClassName() {
        return "";
    }

    @Override
    public IndexerPostProcessor[] getIndexerPostProcessors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        Object[] classNames = this.getSearchClassNames();
        if (ArrayUtil.isEmpty(classNames)) {
            return;
        }
        for (Object className : classNames) {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)className);
            if (indexer == null) continue;
            indexer.postProcessSearchQuery(searchQuery, fullQueryBooleanFilter, searchContext);
        }
    }

    @Override
    protected void doDelete(Object object) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Document doGetDocument(Object object) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    protected void doPostProcessSearchQuery(Indexer<?> indexer, BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
    }

    @Override
    protected void doReindex(Object object) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doReindex(String className, long classPK) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doReindex(String[] ids) throws Exception {
        throw new UnsupportedOperationException();
    }
}

