/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.BaseSearcher;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.FolderIndexer;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.ArrayList;

public class FolderSearcher
extends BaseSearcher {
    private final String[] _classNames;

    public static Indexer<?> getInstance() {
        return new FolderSearcher();
    }

    public FolderSearcher() {
        this.setDefaultSelectedFieldNames("title", "uid");
        this.setFilterSearch(true);
        this.setPermissionAware(true);
        ArrayList<String> folderClassNames = new ArrayList<String>();
        for (Indexer<?> indexer : IndexerRegistryUtil.getIndexers()) {
            if (!(indexer instanceof FolderIndexer)) continue;
            FolderIndexer folderIndexer = (FolderIndexer)((Object)indexer);
            for (String folderClassName : folderIndexer.getFolderClassNames()) {
                folderClassNames.add(folderClassName);
            }
        }
        this._classNames = folderClassNames.toArray(new String[0]);
    }

    @Override
    public String[] getSearchClassNames() {
        return this._classNames;
    }

    @Override
    protected BooleanQuery createFullQuery(BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        TermsFilter entryClassPKTermsFilter = new TermsFilter("entryClassPK");
        entryClassPKTermsFilter.addValues(ArrayUtil.toStringArray(searchContext.getFolderIds()));
        fullQueryBooleanFilter.add(entryClassPKTermsFilter, BooleanClauseOccur.MUST);
        return super.createFullQuery(fullQueryBooleanFilter, searchContext);
    }
}

