/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.security.auth.AuthTokenWhitelist;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;

public class AuthTokenWhitelistUtil {
    private static final ServiceTrackerList<AuthTokenWhitelist> _authTokenWhitelists = ServiceTrackerListFactory.open((BundleContext)SystemBundleUtil.getBundleContext(), AuthTokenWhitelist.class);

    public static boolean isOriginCSRFWhitelisted(long companyId, String origin) {
        for (AuthTokenWhitelist authTokenWhitelist : _authTokenWhitelists) {
            if (!authTokenWhitelist.isOriginCSRFWhitelisted(companyId, origin)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPortletCSRFWhitelisted(HttpServletRequest httpServletRequest, Portlet portlet) {
        for (AuthTokenWhitelist authTokenWhitelist : _authTokenWhitelists) {
            if (!authTokenWhitelist.isPortletCSRFWhitelisted(httpServletRequest, portlet)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPortletInvocationWhitelisted(HttpServletRequest httpServletRequest, Portlet portlet) {
        for (AuthTokenWhitelist authTokenWhitelist : _authTokenWhitelists) {
            if (!authTokenWhitelist.isPortletInvocationWhitelisted(httpServletRequest, portlet)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPortletURLCSRFWhitelisted(LiferayPortletURL liferayPortletURL) {
        for (AuthTokenWhitelist authTokenWhitelist : _authTokenWhitelists) {
            if (!authTokenWhitelist.isPortletURLCSRFWhitelisted(liferayPortletURL)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPortletURLPortletInvocationWhitelisted(LiferayPortletURL liferayPortletURL) {
        for (AuthTokenWhitelist authTokenWhitelist : _authTokenWhitelists) {
            if (!authTokenWhitelist.isPortletURLPortletInvocationWhitelisted(liferayPortletURL)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidSharedSecret(String sharedSecret) {
        for (AuthTokenWhitelist authTokenWhitelist : _authTokenWhitelists) {
            if (!authTokenWhitelist.isValidSharedSecret(sharedSecret)) continue;
            return true;
        }
        return false;
    }
}

