/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.security.auth.AuthTokenWhitelist;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class BaseAuthTokenWhitelist
implements AuthTokenWhitelist {
    protected final List<ServiceRegistration<?>> serviceRegistrations = new ArrayList();
    protected final List<ServiceTracker<Object, Object>> serviceTrackers = new ArrayList<ServiceTracker<Object, Object>>();
    private final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();

    @Override
    public boolean isOriginCSRFWhitelisted(long companyId, String origin) {
        return false;
    }

    @Override
    public boolean isPortletCSRFWhitelisted(HttpServletRequest httpServletRequest, Portlet portlet) {
        return false;
    }

    @Override
    public boolean isPortletInvocationWhitelisted(HttpServletRequest httpServletRequest, Portlet portlet) {
        return false;
    }

    @Override
    public boolean isPortletURLCSRFWhitelisted(LiferayPortletURL liferayPortletURL) {
        return false;
    }

    @Override
    public boolean isPortletURLPortletInvocationWhitelisted(LiferayPortletURL liferayPortletURL) {
        return false;
    }

    @Override
    public boolean isValidSharedSecret(String sharedSecret) {
        return false;
    }

    protected void destroy() {
        this.serviceRegistrations.forEach(ServiceRegistration::unregister);
        for (ServiceTracker<Object, Object> serviceTracker : this.serviceTrackers) {
            serviceTracker.close();
        }
    }

    protected void registerPortalProperty(String key) {
        String[] values = PropsUtil.getArray(key);
        if (values.length > 0) {
            this.serviceRegistrations.add(this._bundleContext.registerService(Object.class, new Object(), MapUtil.singletonDictionary(key, values)));
        }
    }

    protected void trackWhitelistServices(String whitelistName, Set<String> whiteList) {
        ServiceTracker serviceTracker = new ServiceTracker(SystemBundleUtil.getBundleContext(), SystemBundleUtil.createFilter("(" + whitelistName + "=*)"), (ServiceTrackerCustomizer)new TokenWhitelistTrackerCustomizer(whitelistName, whiteList));
        serviceTracker.open();
        this.serviceTrackers.add((ServiceTracker<Object, Object>)serviceTracker);
    }

    private static class TokenWhitelistTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, Object> {
        private final Set<String> _whitelist;
        private final String _whitelistName;

        public TokenWhitelistTrackerCustomizer(String whitelistName, Set<String> whitelist) {
            this._whitelistName = whitelistName;
            this._whitelist = whitelist;
        }

        public Object addingService(ServiceReference<Object> serviceReference) {
            List<String> authTokenIgnoreActions = StringUtil.asList(serviceReference.getProperty(this._whitelistName));
            this._whitelist.addAll(authTokenIgnoreActions);
            return authTokenIgnoreActions;
        }

        public void modifiedService(ServiceReference<Object> serviceReference, Object object) {
            this.removedService(serviceReference, object);
            this.addingService(serviceReference);
        }

        public void removedService(ServiceReference<Object> serviceReference, Object object) {
            Collection authTokenIgnoreActions = (Collection)object;
            this._whitelist.removeAll(authTokenIgnoreActions);
        }
    }
}

