/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.StringUtil;

public class PrincipalException
extends PortalException {
    private static final Class<?>[] _NESTED_CLASSES = new Class[]{PrincipalException.class, MustBeAuthenticated.class, MustBeCompanyAdmin.class, MustBeEnabled.class, MustBeInvokedUsingPost.class, MustBeOmniadmin.class, MustBePortletStrutsPath.class, MustHavePermission.class, MustHaveValidCSRFToken.class, MustHaveSessionCSRFToken.class};

    public static Class<?>[] getNestedClasses() {
        return _NESTED_CLASSES;
    }

    public PrincipalException() {
    }

    public PrincipalException(String msg) {
        super(msg);
    }

    public PrincipalException(String msg, Throwable throwable) {
        super(msg, throwable);
    }

    public PrincipalException(Throwable throwable) {
        super(throwable);
    }

    public static class MustHaveValidCSRFToken
    extends PrincipalException {
        public final String origin;
        public final long userId;

        public MustHaveValidCSRFToken(long userId, String origin) {
            this(userId, origin, null);
        }

        public MustHaveValidCSRFToken(long userId, String origin, Throwable throwable) {
            super(String.format("User %s did not provide a valid CSRF token for %s", userId, origin), throwable);
            this.userId = userId;
            this.origin = origin;
        }
    }

    public static class MustHaveSessionCSRFToken
    extends PrincipalException {
        public final String origin;
        public final long userId;

        public MustHaveSessionCSRFToken(long userId, String origin) {
            this(userId, origin, null);
        }

        public MustHaveSessionCSRFToken(long userId, String origin, Throwable throwable) {
            super(String.format("User %s session does not have a CSRF token for %s", userId, origin), throwable);
            this.userId = userId;
            this.origin = origin;
        }
    }

    public static class MustHavePermission
    extends PrincipalException {
        public final String[] actionId;
        public final long resourceId;
        public final String resourceName;
        public final long userId;

        public MustHavePermission(long userId, String ... actionIds) {
            this(userId, (String)null, 0L, (Throwable)null, actionIds);
        }

        public MustHavePermission(long userId, String resourceName, long resourceId, String ... actionIds) {
            this(userId, resourceName, resourceId, (Throwable)null, actionIds);
        }

        public MustHavePermission(long userId, String resourceName, long resourceId, Throwable throwable, String ... actionIds) {
            super(String.format("User %s must have %s permission for %s %s", userId, StringUtil.merge(actionIds, ","), resourceName, resourceId == 0L ? "" : Long.valueOf(resourceId)), throwable);
            this.userId = userId;
            this.resourceName = resourceName;
            this.resourceId = resourceId;
            this.actionId = actionIds;
        }

        public MustHavePermission(long userId, Throwable throwable, String ... actionIds) {
            this(userId, null, 0L, throwable, actionIds);
        }

        public MustHavePermission(PermissionChecker permissionChecker, String ... actionIds) {
            this(permissionChecker.getUserId(), (String)null, 0L, (Throwable)null, actionIds);
        }

        public MustHavePermission(PermissionChecker permissionChecker, String resourceName, long resourceId, String ... actionIds) {
            this(permissionChecker.getUserId(), resourceName, resourceId, (Throwable)null, actionIds);
        }

        public MustHavePermission(PermissionChecker permissionChecker, String resourceName, long resourceId, Throwable throwable, String ... actionIds) {
            this(permissionChecker.getUserId(), resourceName, resourceId, throwable, actionIds);
        }

        public MustHavePermission(PermissionChecker permissionChecker, Throwable throwable, String ... actionIds) {
            this(permissionChecker.getUserId(), null, 0L, throwable, actionIds);
        }
    }

    public static class MustBePortletStrutsPath
    extends PrincipalException {
        public final String portletId;
        public final String strutsPath;

        public MustBePortletStrutsPath(String strutsPath, String portletId) {
            super(String.format("Struts path %s must be struts path of portlet %s", strutsPath, portletId));
            this.strutsPath = strutsPath;
            this.portletId = portletId;
        }
    }

    public static class MustBeOmniadmin
    extends PrincipalException {
        public final long userId;

        public MustBeOmniadmin(long userId) {
            super(String.format("User %s must be a universal administrator to perform the action", userId));
            this.userId = userId;
        }

        public MustBeOmniadmin(PermissionChecker permissionChecker) {
            this(permissionChecker.getUserId());
        }
    }

    public static class MustBeInvokedUsingPost
    extends PrincipalException {
        public final String url;

        public MustBeInvokedUsingPost(String url) {
            super(String.format("URL %s must be invoked using POST", url));
            this.url = url;
        }
    }

    public static class MustBeGroupAdmin
    extends PrincipalException {
        public final long userId;

        public MustBeGroupAdmin(long userId) {
            super(String.format("User %s must be the site administrator to perform the action", userId));
            this.userId = userId;
        }

        public MustBeGroupAdmin(PermissionChecker permissionChecker) {
            this(permissionChecker.getUserId());
        }
    }

    public static class MustBeEnabled
    extends PrincipalException {
        public final long companyId;
        public final String[] resourceName;

        public MustBeEnabled(long companyId, String ... resourceName) {
            super(String.format("%s must be enabled for company %s", StringUtil.merge(resourceName, ","), companyId));
            this.companyId = companyId;
            this.resourceName = resourceName;
        }
    }

    public static class MustBeCompanyAdmin
    extends PrincipalException {
        public final long userId;

        public MustBeCompanyAdmin(long userId) {
            super(String.format("User %s must be the company administrator to perform the action", userId));
            this.userId = userId;
        }

        public MustBeCompanyAdmin(PermissionChecker permissionChecker) {
            this(permissionChecker.getUserId());
        }
    }

    public static class MustBeAuthenticated
    extends PrincipalException {
        public final String login;

        public MustBeAuthenticated(long userId) {
            this(String.valueOf(userId), null);
        }

        public MustBeAuthenticated(long userId, Throwable throwable) {
            this(String.valueOf(userId), throwable);
        }

        public MustBeAuthenticated(String login) {
            this(login, null);
        }

        public MustBeAuthenticated(String login, Throwable throwable) {
            super(String.format("User %s must be authenticated", login), throwable);
            this.login = login;
        }
    }
}

