/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.permission.resource;

import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.internal.security.permission.resource.PermissionCacheKey;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;

public class ModelResourcePermissionFactory {
    public static <T extends GroupedModel> ModelResourcePermission<T> create(Class<T> modelClass, ToLongFunction<T> primKeyToLongFunction, UnsafeFunction<Long, T, ? extends PortalException> getModelUnsafeFunction, PortletResourcePermission portletResourcePermission, ModelResourcePermissionConfigurator<T> modelResourcePermissionConfigurator) {
        return ModelResourcePermissionFactory.create(modelClass, primKeyToLongFunction, getModelUnsafeFunction, portletResourcePermission, modelResourcePermissionConfigurator, UnaryOperator.identity());
    }

    public static <T extends GroupedModel> ModelResourcePermission<T> create(Class<T> modelClass, ToLongFunction<T> primKeyToLongFunction, UnsafeFunction<Long, T, ? extends PortalException> getModelUnsafeFunction, PortletResourcePermission portletResourcePermission, ModelResourcePermissionConfigurator<T> modelResourcePermissionConfigurator, UnaryOperator<String> actionIdMapper) {
        ArrayList modelResourcePermissionLogics = new ArrayList();
        DefaultModelResourcePermission modelResourcePermission = new DefaultModelResourcePermission(modelResourcePermissionLogics, modelClass, primKeyToLongFunction, getModelUnsafeFunction, portletResourcePermission, actionIdMapper);
        modelResourcePermissionConfigurator.configureModelResourcePermissionLogics(modelResourcePermission, modelResourcePermissionLogics::add);
        return modelResourcePermission;
    }

    private static class DefaultModelResourcePermission<T extends GroupedModel>
    implements ModelResourcePermission<T> {
        private final UnaryOperator<String> _actionIdMapper;
        private final UnsafeFunction<Long, T, ? extends PortalException> _getModelUnsafeFunction;
        private final Class<T> _modelClass;
        private final List<ModelResourcePermissionLogic<T>> _modelResourcePermissionLogics;
        private final PortletResourcePermission _portletResourcePermission;
        private final ToLongFunction<T> _primKeyToLongFunction;

        @Override
        public void check(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
            if (!this.contains(permissionChecker, primaryKey, actionId)) {
                throw new PrincipalException.MustHavePermission(permissionChecker, this._modelClass.getName(), primaryKey, actionId);
            }
        }

        @Override
        public void check(PermissionChecker permissionChecker, T model, String actionId) throws PortalException {
            if (!this.contains(permissionChecker, model, actionId)) {
                throw new PrincipalException.MustHavePermission(permissionChecker, this._modelClass.getName(), this._primKeyToLongFunction.applyAsLong(model), actionId);
            }
        }

        @Override
        public boolean contains(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
            PermissionCacheKey permissionCacheKey;
            Map<Object, Object> permissionChecksMap = permissionChecker.getPermissionChecksMap();
            Boolean contains = (Boolean)permissionChecksMap.get(permissionCacheKey = new PermissionCacheKey(this._modelClass.getName(), primaryKey, actionId));
            if (contains == null) {
                contains = this._contains(permissionChecker, (GroupedModel)this._getModelUnsafeFunction.apply((Object)primaryKey), actionId);
                permissionChecksMap.put(permissionCacheKey, contains);
            }
            return contains;
        }

        @Override
        public boolean contains(PermissionChecker permissionChecker, T model, String actionId) throws PortalException {
            PermissionCacheKey permissionCacheKey;
            Map<Object, Object> permissionChecksMap = permissionChecker.getPermissionChecksMap();
            Boolean contains = (Boolean)permissionChecksMap.get(permissionCacheKey = new PermissionCacheKey(this._modelClass.getName(), this._primKeyToLongFunction.applyAsLong(model), actionId));
            if (contains == null) {
                contains = this._contains(permissionChecker, model, actionId);
                permissionChecksMap.put(permissionCacheKey, contains);
            }
            return contains;
        }

        @Override
        public String getModelName() {
            return this._modelClass.getName();
        }

        @Override
        public PortletResourcePermission getPortletResourcePermission() {
            return this._portletResourcePermission;
        }

        private DefaultModelResourcePermission(List<ModelResourcePermissionLogic<T>> modelResourcePermissionLogics, Class<T> modelClass, ToLongFunction<T> primKeyToLongFunction, UnsafeFunction<Long, T, ? extends PortalException> getModelUnsafeFunction, PortletResourcePermission portletResourcePermission, UnaryOperator<String> actionIdMapper) {
            this._modelResourcePermissionLogics = modelResourcePermissionLogics;
            this._modelClass = Objects.requireNonNull(modelClass);
            this._primKeyToLongFunction = Objects.requireNonNull(primKeyToLongFunction);
            this._getModelUnsafeFunction = Objects.requireNonNull(getModelUnsafeFunction);
            this._portletResourcePermission = portletResourcePermission;
            this._actionIdMapper = Objects.requireNonNull(actionIdMapper);
        }

        private boolean _contains(PermissionChecker permissionChecker, T model, String actionId) throws PortalException {
            actionId = (String)this._actionIdMapper.apply(actionId);
            for (ModelResourcePermissionLogic<T> modelResourcePermissionLogic : this._modelResourcePermissionLogics) {
                Boolean contains = modelResourcePermissionLogic.contains(permissionChecker, this._modelClass.getName(), model, actionId);
                if (contains == null) continue;
                return contains;
            }
            String primKey = String.valueOf(this._primKeyToLongFunction.applyAsLong(model));
            if (permissionChecker.hasOwnerPermission(model.getCompanyId(), this._modelClass.getName(), primKey, model.getUserId(), actionId)) {
                return true;
            }
            return permissionChecker.hasPermission(model.getGroupId(), this._modelClass.getName(), primKey, actionId);
        }
    }

    @FunctionalInterface
    public static interface ModelResourcePermissionConfigurator<T extends GroupedModel> {
        public void configureModelResourcePermissionLogics(ModelResourcePermission<T> var1, Consumer<ModelResourcePermissionLogic<T>> var2);
    }
}

