/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.pwd;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PwdEncryptorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptor;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import org.osgi.framework.BundleContext;

public class PasswordEncryptorUtil {
    private static final String _PASSWORDS_ENCRYPTION_ALGORITHM = StringUtil.toUpperCase(GetterUtil.getString(PropsUtil.get("passwords.encryption.algorithm")));
    private static final Log _log = LogFactoryUtil.getLog(PasswordEncryptorUtil.class);
    private static final ServiceTrackerMap<String, PasswordEncryptor> _serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)SystemBundleUtil.getBundleContext(), PasswordEncryptor.class, (String)"type");

    public static String encrypt(String plainTextPassword) throws PwdEncryptorException {
        return PasswordEncryptorUtil.encrypt(plainTextPassword, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encrypt(String plainTextPassword, String encryptedPassword) throws PwdEncryptorException {
        long startTime = 0L;
        if (_log.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
        }
        try {
            String string = PasswordEncryptorUtil.encrypt(_PASSWORDS_ENCRYPTION_ALGORITHM, plainTextPassword, encryptedPassword);
            return string;
        }
        finally {
            if (_log.isDebugEnabled()) {
                _log.debug("Password encrypted in " + (System.currentTimeMillis() - startTime) + "ms");
            }
        }
    }

    public static String encrypt(String plainTextPassword, String encryptedPassword, boolean upgradeHashSecurity) throws PwdEncryptorException {
        if (upgradeHashSecurity) {
            encryptedPassword = null;
        }
        return PasswordEncryptorUtil._encrypt(null, plainTextPassword, encryptedPassword, upgradeHashSecurity);
    }

    public static String encrypt(String algorithm, String plainTextPassword, String encryptedPassword) throws PwdEncryptorException {
        return PasswordEncryptorUtil._encrypt(algorithm, plainTextPassword, encryptedPassword, false);
    }

    private static String _encrypt(String algorithm, String plainTextPassword, String encryptedPassword, boolean upgradeHashSecurity) throws PwdEncryptorException {
        if (Validator.isNull(plainTextPassword)) {
            throw new PwdEncryptorException("Unable to _encrypt blank password");
        }
        boolean prependAlgorithm = true;
        if (upgradeHashSecurity) {
            algorithm = _PASSWORDS_ENCRYPTION_ALGORITHM;
            encryptedPassword = null;
        } else {
            int index;
            String encryptedPasswordAlgorithm = PasswordEncryptorUtil._getEncryptedPasswordAlgorithm(encryptedPassword);
            if (Validator.isNotNull(encryptedPasswordAlgorithm)) {
                algorithm = encryptedPasswordAlgorithm;
            }
            if (Validator.isNotNull(encryptedPassword) && encryptedPassword.charAt(0) != '{') {
                prependAlgorithm = false;
            } else if (Validator.isNotNull(encryptedPassword) && encryptedPassword.charAt(0) == '{' && (index = encryptedPassword.indexOf(125)) > 0) {
                encryptedPassword = encryptedPassword.substring(index + 1);
            }
            if (Validator.isNull(algorithm)) {
                algorithm = _PASSWORDS_ENCRYPTION_ALGORITHM;
            }
        }
        PasswordEncryptor passwordEncryptor = PasswordEncryptorUtil._select(algorithm);
        String newEncryptedPassword = passwordEncryptor.encrypt(algorithm, plainTextPassword, encryptedPassword, false);
        if (!prependAlgorithm) {
            if (_log.isDebugEnabled()) {
                _log.debug("Generated password without algorithm prefix using " + algorithm);
            }
            return newEncryptedPassword;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Generated password with algorithm prefix using " + algorithm);
        }
        return StringBundler.concat((String[])new String[]{"{", PasswordEncryptorUtil._getAlgorithmName(algorithm), "}", newEncryptedPassword});
    }

    private static String _getAlgorithmName(String algorithm) {
        int index = algorithm.indexOf(47);
        if (index > 0) {
            return algorithm.substring(0, index);
        }
        return algorithm;
    }

    private static String _getEncryptedPasswordAlgorithm(String encryptedPassword) {
        int index;
        String legacyAlgorithm = GetterUtil.getString(PropsUtil.get("passwords.encryption.algorithm.legacy"));
        if (_log.isDebugEnabled() && Validator.isNotNull(legacyAlgorithm)) {
            if (Validator.isNull(encryptedPassword)) {
                _log.debug(StringBundler.concat((String[])new String[]{"Using legacy detection scheme for algorithm ", legacyAlgorithm, " with empty password"}));
            } else {
                _log.debug(StringBundler.concat((String[])new String[]{"Using legacy detection scheme for algorithm ", legacyAlgorithm, " with provided password"}));
            }
        }
        if (Validator.isNotNull(encryptedPassword) && encryptedPassword.charAt(0) != '{') {
            if (_log.isDebugEnabled()) {
                _log.debug("Using legacy algorithm " + legacyAlgorithm);
            }
            if (Validator.isNotNull(legacyAlgorithm)) {
                return legacyAlgorithm;
            }
            return _PASSWORDS_ENCRYPTION_ALGORITHM;
        }
        if (Validator.isNotNull(encryptedPassword) && encryptedPassword.charAt(0) == '{' && (index = encryptedPassword.indexOf(125)) > 0) {
            String algorithm = encryptedPassword.substring(1, index);
            if (_log.isDebugEnabled()) {
                _log.debug("Upgraded password to use algorithm " + algorithm);
            }
            return algorithm;
        }
        return null;
    }

    private static PasswordEncryptor _select(String algorithm) {
        if (Validator.isNull(algorithm)) {
            throw new IllegalArgumentException("Invalid algorithm");
        }
        PasswordEncryptor passwordEncryptor = null;
        passwordEncryptor = algorithm.startsWith("BCRYPT") ? (PasswordEncryptor)_serviceTrackerMap.getService((Object)"BCRYPT") : (algorithm.startsWith("PBKDF2") ? (PasswordEncryptor)_serviceTrackerMap.getService((Object)"PBKDF2") : (algorithm.indexOf(47) > 0 ? (PasswordEncryptor)_serviceTrackerMap.getService((Object)algorithm.substring(0, algorithm.indexOf(47))) : (PasswordEncryptor)_serviceTrackerMap.getService((Object)algorithm)));
        if (passwordEncryptor == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No password encryptor found for " + algorithm);
            }
            passwordEncryptor = (PasswordEncryptor)_serviceTrackerMap.getService((Object)"DEFAULT");
        }
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat((String[])new String[]{"Found ", ClassUtil.getClassName(passwordEncryptor), " to _encrypt password using ", algorithm}));
        }
        return passwordEncryptor;
    }
}

