/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service.permission;

import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import java.util.Objects;

public class RolePermissionUtil {
    public static void check(PermissionChecker permissionChecker, long roleId, String actionId) throws PrincipalException {
        if (!RolePermissionUtil.contains(permissionChecker, roleId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Role.class.getName(), roleId, actionId);
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long roleId, String actionId) {
        Role role;
        if (Objects.equals("ASSIGN_MEMBERS", actionId) && (role = RoleLocalServiceUtil.fetchRole(roleId)) != null && Objects.equals("Administrator", role.getName()) && !permissionChecker.isCompanyAdmin()) {
            return false;
        }
        return permissionChecker.hasPermission(groupId, Role.class.getName(), roleId, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long roleId, String actionId) {
        return RolePermissionUtil.contains(permissionChecker, 0L, roleId, actionId);
    }
}

