/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service.permission;

import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.TeamLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;

public class TeamPermissionUtil {
    public static void check(PermissionChecker permissionChecker, long teamId, String actionId) throws PortalException {
        if (!TeamPermissionUtil.contains(permissionChecker, teamId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Team.class.getName(), teamId, actionId);
        }
    }

    public static void check(PermissionChecker permissionChecker, Team team, String actionId) throws PortalException {
        if (!TeamPermissionUtil.contains(permissionChecker, team, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Team.class.getName(), team.getTeamId(), actionId);
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long teamId, String actionId) throws PortalException {
        return TeamPermissionUtil.contains(permissionChecker, TeamLocalServiceUtil.getTeam(teamId), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, Team team, String actionId) throws PortalException {
        Boolean hasPermission = StagingPermissionUtil.hasPermission(permissionChecker, team.getGroupId(), Team.class.getName(), team.getTeamId(), "", actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        if (GroupPermissionUtil.contains(permissionChecker, team.getGroupId(), "MANAGE_TEAMS") || permissionChecker.hasOwnerPermission(team.getCompanyId(), Team.class.getName(), team.getTeamId(), team.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(team.getGroupId(), Team.class.getName(), team.getTeamId(), actionId);
    }
}

