/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service.permission;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.util.PortalUtil;

public class UserPermissionUtil {
    private static final Log _log = LogFactoryUtil.getLog(UserPermissionUtil.class);

    public static void check(PermissionChecker permissionChecker, long userId, long[] organizationIds, String actionId) throws PrincipalException {
        if (!UserPermissionUtil.contains(permissionChecker, userId, organizationIds, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, User.class.getName(), userId, actionId);
        }
    }

    public static void check(PermissionChecker permissionChecker, long userId, String actionId) throws PrincipalException {
        if (!UserPermissionUtil.contains(permissionChecker, userId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, User.class.getName(), userId, actionId);
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long userId, long[] organizationIds, String actionId) {
        block14: {
            try {
                User user = null;
                if (userId != -1L) {
                    if (permissionChecker.isOmniadmin()) {
                        return true;
                    }
                    user = UserLocalServiceUtil.getUserById(userId);
                    if (!actionId.equals("VIEW") && !permissionChecker.isOmniadmin() && (PortalUtil.isOmniadmin(user) || !permissionChecker.isCompanyAdmin() && PortalUtil.isCompanyAdmin(user))) {
                        return false;
                    }
                    Contact contact = user.getContact();
                    if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), User.class.getName(), userId, contact.getUserId(), actionId) || permissionChecker.getUserId() == userId && !actionId.equals("PERMISSIONS") || permissionChecker.hasPermission(null, User.class.getName(), userId, actionId)) {
                        return true;
                    }
                } else if (permissionChecker.hasPermission(null, User.class.getName(), User.class.getName(), actionId)) {
                    return true;
                }
                if (user == null) {
                    return false;
                }
                if (organizationIds == null) {
                    organizationIds = user.getOrganizationIds();
                }
                for (long organizationId : organizationIds) {
                    Organization organization = OrganizationLocalServiceUtil.getOrganization(organizationId);
                    if (!OrganizationPermissionUtil.contains(permissionChecker, organization, "MANAGE_USERS")) continue;
                    if (permissionChecker.getUserId() == user.getUserId()) {
                        return true;
                    }
                    if (!UserGroupRoleLocalServiceUtil.hasUserGroupRole(user.getUserId(), organization.getGroupId(), "Organization Administrator", true) && !UserGroupRoleLocalServiceUtil.hasUserGroupRole(user.getUserId(), organization.getGroupId(), "Organization Owner", true)) {
                        return true;
                    }
                    for (Organization curOrganization = organization; curOrganization != null; curOrganization = curOrganization.getParentOrganization()) {
                        if (!UserGroupRoleLocalServiceUtil.hasUserGroupRole(permissionChecker.getUserId(), curOrganization.getGroupId(), "Organization Owner", true)) continue;
                        return true;
                    }
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block14;
                _log.debug(exception);
            }
        }
        return false;
    }

    public static boolean contains(PermissionChecker permissionChecker, long userId, String actionId) {
        return UserPermissionUtil.contains(permissionChecker, userId, null, actionId);
    }
}

