/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.model.NestedSetsTreeNodeModel;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.service.persistence.impl.NestedSetsTreeManager;
import java.util.Iterator;
import java.util.List;

public class PersistenceNestedSetsTreeManager<T extends NestedSetsTreeNodeModel>
extends NestedSetsTreeManager<T> {
    private final BasePersistenceImpl<?> _basePersistenceImpl;
    private final Class<?> _entityImplClass;
    private final String _entityName;
    private final String _nestedSetsTreeNodeLeftName;
    private final String _nestedSetsTreeNodeRightName;
    private final String _nestedSetsTreeNodeScopeIdName;
    private final String _primaryKeyName;
    private final String _tableName;

    public PersistenceNestedSetsTreeManager(BasePersistenceImpl<?> basePersistenceImpl, String tableName, String entityName, Class<?> entityImplClass, String primaryKeyName, String nestedSetsTreeNodeScopeIdName, String nestedSetsTreeNodeLeftName, String nestedSetsTreeNodeRightName) {
        this._basePersistenceImpl = basePersistenceImpl;
        this._tableName = tableName;
        this._entityName = entityName;
        this._entityImplClass = entityImplClass;
        this._primaryKeyName = primaryKeyName;
        this._nestedSetsTreeNodeScopeIdName = nestedSetsTreeNodeScopeIdName;
        this._nestedSetsTreeNodeLeftName = nestedSetsTreeNodeLeftName;
        this._nestedSetsTreeNodeRightName = nestedSetsTreeNodeRightName;
    }

    @Override
    protected long doCountAncestors(long nestedSetsTreeNodeScopeId, long nestedSetsTreeNodeLeft, long nestedSetsTreeNodeRight) {
        Session session = null;
        try {
            session = this._basePersistenceImpl.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(StringBundler.concat((String[])new String[]{"SELECT count(*) FROM ", this._tableName, " WHERE ", this._nestedSetsTreeNodeScopeIdName, " = ? AND ", this._nestedSetsTreeNodeLeftName, " <= ? AND ", this._nestedSetsTreeNodeRightName, " >= ?"}));
            QueryPos queryPos = QueryPos.getInstance(sqlQuery);
            queryPos.add(nestedSetsTreeNodeScopeId);
            queryPos.add(nestedSetsTreeNodeLeft);
            queryPos.add(nestedSetsTreeNodeRight);
            Number number = (Number)sqlQuery.uniqueResult();
            long l = number.longValue();
            return l;
        }
        catch (Exception exception) {
            throw this._basePersistenceImpl.processException(exception);
        }
        finally {
            this._basePersistenceImpl.closeSession(session);
        }
    }

    @Override
    protected long doCountDescendants(long nestedSetsTreeNodeScopeId, long nestedSetsTreeNodeLeft, long nestedSetsTreeNodeRight) {
        Session session = null;
        try {
            session = this._basePersistenceImpl.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(StringBundler.concat((String[])new String[]{"SELECT count(*) FROM ", this._tableName, " WHERE ", this._nestedSetsTreeNodeScopeIdName, " = ? AND ", this._nestedSetsTreeNodeLeftName, " >= ? AND ", this._nestedSetsTreeNodeRightName, " <= ?"}));
            QueryPos queryPos = QueryPos.getInstance(sqlQuery);
            queryPos.add(nestedSetsTreeNodeScopeId);
            queryPos.add(nestedSetsTreeNodeLeft);
            queryPos.add(nestedSetsTreeNodeRight);
            Number number = (Number)sqlQuery.uniqueResult();
            long l = number.longValue();
            return l;
        }
        catch (Exception exception) {
            throw this._basePersistenceImpl.processException(exception);
        }
        finally {
            this._basePersistenceImpl.closeSession(session);
        }
    }

    @Override
    protected List<T> doGetAncestors(long nestedSetsTreeNodeScopeId, long nestedSetsTreeNodeLeft, long nestedSetsTreeNodeRight) {
        Session session = null;
        try {
            session = this._basePersistenceImpl.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(StringBundler.concat((String[])new String[]{"SELECT {", this._entityName, ".*} FROM ", this._tableName, " WHERE ", this._nestedSetsTreeNodeScopeIdName, " = ? AND ", this._nestedSetsTreeNodeLeftName, " <= ? AND ", this._nestedSetsTreeNodeRightName, " >= ?"}));
            sqlQuery.addEntity(this._entityName, this._entityImplClass);
            QueryPos queryPos = QueryPos.getInstance(sqlQuery);
            queryPos.add(nestedSetsTreeNodeScopeId);
            queryPos.add(nestedSetsTreeNodeLeft);
            queryPos.add(nestedSetsTreeNodeRight);
            List<?> list = QueryUtil.list(sqlQuery, this._basePersistenceImpl.getDialect(), -1, -1);
            return list;
        }
        catch (Exception exception) {
            throw this._basePersistenceImpl.processException(exception);
        }
        finally {
            this._basePersistenceImpl.closeSession(session);
        }
    }

    @Override
    protected List<T> doGetDescendants(long nestedSetsTreeNodeScopeId, long nestedSetsTreeNodeLeft, long nestedSetsTreeNodeRight) {
        Session session = null;
        try {
            session = this._basePersistenceImpl.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(StringBundler.concat((String[])new String[]{"SELECT {", this._entityName, ".*} FROM ", this._tableName, " WHERE ", this._nestedSetsTreeNodeScopeIdName, " = ? AND ", this._nestedSetsTreeNodeLeftName, " >= ? AND ", this._nestedSetsTreeNodeRightName, " <= ?"}));
            sqlQuery.addEntity(this._entityName, this._entityImplClass);
            QueryPos queryPos = QueryPos.getInstance(sqlQuery);
            queryPos.add(nestedSetsTreeNodeScopeId);
            queryPos.add(nestedSetsTreeNodeLeft);
            queryPos.add(nestedSetsTreeNodeRight);
            List<?> list = QueryUtil.list(sqlQuery, this._basePersistenceImpl.getDialect(), -1, -1);
            return list;
        }
        catch (Exception exception) {
            throw this._basePersistenceImpl.processException(exception);
        }
        finally {
            this._basePersistenceImpl.closeSession(session);
        }
    }

    protected void doUpdate(boolean leftOrRight, long nestedSetsTreeNodeScopeId, long delta, long start, boolean startInclusive, long end, boolean endInclusive, List<T> includeList) {
        StringBundler sb = null;
        sb = includeList == null ? new StringBundler(14) : new StringBundler(17 + includeList.size() * 2);
        sb.append("UPDATE ");
        sb.append(this._tableName);
        sb.append(" SET ");
        if (leftOrRight) {
            sb.append(this._nestedSetsTreeNodeLeftName);
            sb.append(" = (");
            sb.append(this._nestedSetsTreeNodeLeftName);
            sb.append(" + ?)");
        } else {
            sb.append(this._nestedSetsTreeNodeRightName);
            sb.append(" = (");
            sb.append(this._nestedSetsTreeNodeRightName);
            sb.append(" + ?)");
        }
        sb.append(" WHERE ");
        sb.append(this._nestedSetsTreeNodeScopeIdName);
        sb.append(" = ? AND ");
        if (leftOrRight) {
            sb.append(this._nestedSetsTreeNodeLeftName);
        } else {
            sb.append(this._nestedSetsTreeNodeRightName);
        }
        if (startInclusive) {
            sb.append(" >= ? AND ");
        } else {
            sb.append(" > ? AND ");
        }
        if (leftOrRight) {
            sb.append(this._nestedSetsTreeNodeLeftName);
        } else {
            sb.append(this._nestedSetsTreeNodeRightName);
        }
        if (endInclusive) {
            sb.append(" <= ? ");
        } else {
            sb.append(" < ? ");
        }
        if (includeList != null) {
            sb.append(" AND ");
            sb.append(this._primaryKeyName);
            sb.append(" IN(");
            for (NestedSetsTreeNodeModel t : includeList) {
                sb.append(t.getPrimaryKey());
                sb.append(", ");
            }
            sb.setIndex(sb.index() - 1);
            sb.append(")");
        }
        Session session = null;
        try {
            session = this._basePersistenceImpl.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sb.toString());
            QueryPos queryPos = QueryPos.getInstance(sqlQuery);
            queryPos.add(delta);
            queryPos.add(nestedSetsTreeNodeScopeId);
            queryPos.add(start);
            queryPos.add(end);
            sqlQuery.executeUpdate();
        }
        catch (Exception exception) {
            throw this._basePersistenceImpl.processException(exception);
        }
        finally {
            this._basePersistenceImpl.closeSession(session);
        }
    }

    @Override
    protected void doUpdate(long nestedSetsTreeNodeScopeId, boolean leftOrRight, long delta, long limit, boolean inclusive) {
        StringBundler sb = new StringBundler(12);
        sb.append("UPDATE ");
        sb.append(this._tableName);
        sb.append(" SET ");
        if (leftOrRight) {
            sb.append(this._nestedSetsTreeNodeLeftName);
            sb.append(" = (");
            sb.append(this._nestedSetsTreeNodeLeftName);
            sb.append(" + ?)");
        } else {
            sb.append(this._nestedSetsTreeNodeRightName);
            sb.append(" = (");
            sb.append(this._nestedSetsTreeNodeRightName);
            sb.append(" + ?)");
        }
        sb.append(" WHERE ");
        sb.append(this._nestedSetsTreeNodeScopeIdName);
        sb.append(" = ? AND ");
        if (leftOrRight) {
            sb.append(this._nestedSetsTreeNodeLeftName);
        } else {
            sb.append(this._nestedSetsTreeNodeRightName);
        }
        if (inclusive) {
            sb.append(" >= ?");
        } else {
            sb.append(" > ?");
        }
        Session session = null;
        try {
            session = this._basePersistenceImpl.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sb.toString());
            QueryPos queryPos = QueryPos.getInstance(sqlQuery);
            queryPos.add(delta);
            queryPos.add(nestedSetsTreeNodeScopeId);
            queryPos.add(limit);
            sqlQuery.executeUpdate();
        }
        catch (Exception exception) {
            throw this._basePersistenceImpl.processException(exception);
        }
        finally {
            this._basePersistenceImpl.closeSession(session);
        }
    }

    @Override
    protected void doUpdate(long nestedSetsTreeNodeScopeId, long delta, long start, boolean startInclusive, long end, boolean endInclusive, List<T> includeList) {
        this.doUpdate(false, nestedSetsTreeNodeScopeId, delta, start, startInclusive, end, endInclusive, includeList);
        this.doUpdate(true, nestedSetsTreeNodeScopeId, delta, start, startInclusive, end, endInclusive, includeList);
    }

    @Override
    protected long getMaxNestedSetsTreeNodeRight(long nestedSetsTreeNodeScopeId) {
        Session session = null;
        try {
            session = this._basePersistenceImpl.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(StringBundler.concat((String[])new String[]{"SELECT MAX(", this._nestedSetsTreeNodeRightName, ") AS maxNestedSetsTreeNodeRight FROM ", this._tableName, " WHERE ", this._nestedSetsTreeNodeScopeIdName, " = ? AND ", this._nestedSetsTreeNodeRightName, " > 0"}));
            sqlQuery.addScalar("maxNestedSetsTreeNodeRight", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance(sqlQuery);
            queryPos.add(nestedSetsTreeNodeScopeId);
            Iterator<?> iterator = QueryUtil.iterate(sqlQuery, this._basePersistenceImpl.getDialect(), -1, -1);
            Long maxNSRight = (Long)iterator.next();
            if (maxNSRight != null) {
                long l = maxNSRight + 1L;
                return l;
            }
            long l = 1L;
            return l;
        }
        catch (Exception exception) {
            throw this._basePersistenceImpl.processException(exception);
        }
        finally {
            this._basePersistenceImpl.closeSession(session);
        }
    }
}

