/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.concurrent.FutureListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class InitialRequestSyncUtil {
    private static final Log _log = LogFactoryUtil.getLog(InitialRequestSyncUtil.class);
    private static final DefaultNoticeableFuture<Void> _syncCallableDefaultNoticeableFuture = new DefaultNoticeableFuture();

    public static void registerSyncCallable(Callable<?> syncCallable) {
        InitialRequestSyncUtil._addFutureListener(_syncCallableDefaultNoticeableFuture, future -> {
            try {
                syncCallable.call();
            }
            catch (Exception exception) {
                _log.error("Unable to sync callable", exception);
            }
        });
    }

    public static void sync() {
        if (_syncCallableDefaultNoticeableFuture.isDone()) {
            return;
        }
        _syncCallableDefaultNoticeableFuture.run();
    }

    private static void _addFutureListener(final DefaultNoticeableFuture<Void> defaultNoticeableFuture, final FutureListener<Void> futureListener) {
        defaultNoticeableFuture.addFutureListener(new FutureListener<Void>(){

            @Override
            public void complete(Future<Void> future) {
                futureListener.complete(future);
                defaultNoticeableFuture.removeFutureListener(this);
            }
        });
    }
}

