/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JasperVersionDetector {
    private static final Log _log = LogFactoryUtil.getLog(JasperVersionDetector.class);
    private static final JasperVersionDetector _jasperVersionDetector = new JasperVersionDetector();
    private String _jasperVersion = "";
    private boolean _jspServletDependantsMap;

    public static String getJasperVersion() {
        return JasperVersionDetector._jasperVersionDetector._jasperVersion;
    }

    public static boolean hasJspServletDependantsMap() {
        return JasperVersionDetector._jasperVersionDetector._jspServletDependantsMap;
    }

    private JasperVersionDetector() {
        this._initializeJasperVersion();
        this._initializeJspServletDependantsMap();
    }

    private void _initializeJasperVersion() {
        Class<?> clazz = this.getClass();
        URL url = clazz.getResource("/org/apache/jasper/JasperException.class");
        if (url == null) {
            return;
        }
        String path = url.getPath();
        int pos = path.indexOf(33);
        if (pos == -1) {
            return;
        }
        try (JarFile jarFile = new JarFile(new File(new URI(path.substring(0, pos))));){
            Attributes.Name bundleVersionAttributesName;
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            if (attributes.containsKey(Attributes.Name.SPECIFICATION_VERSION)) {
                this._jasperVersion = GetterUtil.getString(attributes.getValue(Attributes.Name.SPECIFICATION_VERSION));
                if (this._isValidJasperVersion(this._jasperVersion)) {
                    return;
                }
            }
            if (attributes.containsKey(Attributes.Name.IMPLEMENTATION_VERSION)) {
                this._jasperVersion = GetterUtil.getString(attributes.get(Attributes.Name.IMPLEMENTATION_VERSION));
                if (this._isValidJasperVersion(this._jasperVersion)) {
                    return;
                }
            }
            if (attributes.containsKey(bundleVersionAttributesName = new Attributes.Name("Bundle-Version"))) {
                this._jasperVersion = GetterUtil.getString(attributes.get(bundleVersionAttributesName));
                if (this._isValidJasperVersion(this._jasperVersion)) {
                    return;
                }
                this._jasperVersion = "";
            }
        }
        catch (Exception exception) {
            _log.error(exception);
        }
    }

    private void _initializeJspServletDependantsMap() {
        try {
            Class<?> clazz = Class.forName("org.apache.jasper.servlet.JspServletWrapper");
            Method method = ReflectionUtil.getDeclaredMethod(clazz, (String)"getDependants", (Class[])new Class[0]);
            this._jspServletDependantsMap = Map.class.isAssignableFrom(method.getReturnType());
        }
        catch (Exception exception) {
            _log.error(exception);
        }
    }

    private boolean _isValidJasperVersion(String jasperVersion) {
        return !Validator.isNull(jasperVersion) && Validator.isDigit(jasperVersion.charAt(0));
    }
}

