/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.petra.io.OutputStreamWriter;
import com.liferay.petra.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.io.WriterOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletOutputStreamAdapter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class PipingServletResponse
extends HttpServletResponseWrapper {
    private static final Log _log = LogFactoryUtil.getLog(PipingServletResponse.class);
    private PrintWriter _printWriter;
    private ServletOutputStream _servletOutputStream;

    public PipingServletResponse(HttpServletResponse httpServletResponse, OutputStream outputStream) {
        super(httpServletResponse);
        if (outputStream == null) {
            throw new NullPointerException("Output stream is null");
        }
        this._servletOutputStream = new ServletOutputStreamAdapter(outputStream);
    }

    public PipingServletResponse(HttpServletResponse httpServletResponse, PrintWriter printWriter) {
        super(httpServletResponse);
        if (printWriter == null) {
            throw new NullPointerException("Print writer is null");
        }
        this._printWriter = printWriter;
    }

    public PipingServletResponse(HttpServletResponse httpServletResponse, ServletOutputStream servletOutputStream) {
        super(httpServletResponse);
        if (servletOutputStream == null) {
            throw new NullPointerException("Servlet output stream is null");
        }
        this._servletOutputStream = servletOutputStream;
    }

    public PipingServletResponse(HttpServletResponse httpServletResponse, Writer writer) {
        super(httpServletResponse);
        if (writer == null) {
            throw new NullPointerException("Writer is null");
        }
        this._printWriter = new UnsyncPrintWriter(writer);
    }

    public ServletOutputStream getOutputStream() {
        if (this._servletOutputStream == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("Getting an output stream when a writer is available is not recommended because it is slow");
            }
            this._servletOutputStream = new ServletOutputStreamAdapter(new WriterOutputStream(this._printWriter, this.getCharacterEncoding(), this.getBufferSize(), true));
        }
        return this._servletOutputStream;
    }

    public PrintWriter getWriter() {
        if (this._printWriter == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("Getting a writer when an output stream is available is not recommended because it is slow");
            }
            this._printWriter = new UnsyncPrintWriter((Writer)new OutputStreamWriter((OutputStream)this._servletOutputStream, this.getCharacterEncoding(), true));
        }
        return this._printWriter;
    }
}

