/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class PortletResourcesUtil {
    private static final Log _log = LogFactoryUtil.getLog(PortletResourcesUtil.class);
    private static final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private static final ServiceTracker<Portlet, Portlet> _serviceTracker;
    private static final Map<ServiceReference<Portlet>, ServletContext> _servletContexts;

    public static ServletContext getPathServletContext(String path) {
        for (ServletContext servletContext : _servletContexts.values()) {
            if (!path.startsWith(servletContext.getContextPath())) continue;
            return servletContext;
        }
        return null;
    }

    public static URL getResource(ServletContext servletContext, String path) {
        block4: {
            if (servletContext == null) {
                return null;
            }
            path = PortalWebResourcesUtil.stripContextPath(servletContext, path);
            try {
                URL url = servletContext.getResource(path);
                if (url != null) {
                    return url;
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug(malformedURLException);
            }
        }
        return null;
    }

    public static URL getResource(String path) {
        ServletContext servletContext = PortletResourcesUtil.getPathServletContext(path);
        if (servletContext != null) {
            return PortletResourcesUtil.getResource(servletContext, path);
        }
        return null;
    }

    private PortletResourcesUtil() {
    }

    static {
        _servletContexts = new ConcurrentHashMap<ServiceReference<Portlet>, ServletContext>();
        _serviceTracker = new ServiceTracker(_bundleContext, Portlet.class, (ServiceTrackerCustomizer)new PortletResourcesServiceTrackerCustomizer());
        _serviceTracker.open();
    }

    private static class PortletResourcesServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Portlet, Portlet> {
        private PortletResourcesServiceTrackerCustomizer() {
        }

        public Portlet addingService(ServiceReference<Portlet> serviceReference) {
            Portlet portlet = (Portlet)_bundleContext.getService(serviceReference);
            PortletApp portletApp = portlet.getPortletApp();
            if (portletApp.isWARFile()) {
                _servletContexts.put(serviceReference, portletApp.getServletContext());
            }
            return portlet;
        }

        public void modifiedService(ServiceReference<Portlet> serviceReference, Portlet portlet) {
        }

        public void removedService(ServiceReference<Portlet> serviceReference, Portlet portlet) {
            _bundleContext.ungetService(serviceReference);
            _servletContexts.remove(serviceReference);
        }
    }
}

