/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.petra.io.OutputStreamWriter;
import com.liferay.petra.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.internal.servlet.RestrictedByteArrayCacheOutputStream;
import com.liferay.portal.kernel.servlet.MetaInfoCacheServletResponse;
import com.liferay.portal.kernel.servlet.ServletOutputStreamAdapter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class RestrictedByteBufferCacheServletResponse
extends MetaInfoCacheServletResponse {
    private static final ByteBuffer _emptyByteBuffer = ByteBuffer.allocate(0);
    private final int _cacheCapacity;
    private PrintWriter _printWriter;
    private RestrictedByteArrayCacheOutputStream _restrictedByteArrayCacheOutputStream;
    private ServletOutputStream _servletOutputStream;

    public RestrictedByteBufferCacheServletResponse(HttpServletResponse httpServletResponse, int cacheCapacity) {
        super(httpServletResponse);
        this._cacheCapacity = cacheCapacity;
    }

    public void flushCache() throws IOException {
        if (this._restrictedByteArrayCacheOutputStream != null) {
            this._restrictedByteArrayCacheOutputStream.flush();
        }
    }

    @Override
    public int getBufferSize() {
        if (this.isOverflowed()) {
            return super.getBufferSize();
        }
        if (this._restrictedByteArrayCacheOutputStream == null) {
            return this._cacheCapacity;
        }
        return this._restrictedByteArrayCacheOutputStream.getCacheCapacity();
    }

    public ByteBuffer getByteBuffer() {
        if (this._restrictedByteArrayCacheOutputStream == null) {
            return _emptyByteBuffer;
        }
        return this._restrictedByteArrayCacheOutputStream.unsafeGetByteBuffer();
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        if (this.calledGetWriter) {
            throw new IllegalStateException("Unable to obtain OutputStream because Writer is already in use");
        }
        if (this._servletOutputStream != null) {
            return this._servletOutputStream;
        }
        this._restrictedByteArrayCacheOutputStream = new RestrictedByteArrayCacheOutputStream((OutputStream)super.getOutputStream(), this._cacheCapacity, new FinishResponseFlushPreAction());
        this._servletOutputStream = new ServletOutputStreamAdapter(this._restrictedByteArrayCacheOutputStream);
        this.calledGetOutputStream = true;
        return this._servletOutputStream;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this.calledGetOutputStream) {
            throw new IllegalStateException("Unable to obtain Writer because OutputStream is already in use");
        }
        if (this._printWriter != null) {
            return this._printWriter;
        }
        ServletResponse servletResponse = this.getResponse();
        this._restrictedByteArrayCacheOutputStream = new RestrictedByteArrayCacheOutputStream((OutputStream)servletResponse.getOutputStream(), this._cacheCapacity, new FinishResponseFlushPreAction());
        this._printWriter = new UnsyncPrintWriter((Writer)new OutputStreamWriter((OutputStream)this._restrictedByteArrayCacheOutputStream, this.getCharacterEncoding(), true));
        this.calledGetWriter = true;
        return this._printWriter;
    }

    public boolean isOverflowed() {
        if (this._restrictedByteArrayCacheOutputStream == null) {
            return this._cacheCapacity < super.getBufferSize();
        }
        return this._restrictedByteArrayCacheOutputStream.isOverflowed();
    }

    @Override
    public void setBufferSize(int bufferSize) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Set buffer size after commit");
        }
        if (bufferSize > this.getBufferSize()) {
            super.setBufferSize(bufferSize);
            try {
                this.flushCache();
            }
            catch (IOException ioException) {
                throw new IllegalStateException("Unable to transfer restricted byte buffer to underneathresponse's buffer", ioException);
            }
        }
    }

    @Override
    protected void resetBuffer(boolean nullOutReferences) {
        if (nullOutReferences) {
            this.calledGetOutputStream = false;
            this.calledGetWriter = false;
            this._printWriter = null;
            this._servletOutputStream = null;
            this._restrictedByteArrayCacheOutputStream = null;
        } else if (this._restrictedByteArrayCacheOutputStream != null) {
            this._restrictedByteArrayCacheOutputStream.reset();
        }
    }

    private class FinishResponseFlushPreAction
    implements RestrictedByteArrayCacheOutputStream.FlushPreAction {
        private FinishResponseFlushPreAction() {
        }

        @Override
        public void beforeFlush() throws IOException {
            RestrictedByteBufferCacheServletResponse.this.flushBuffer();
        }
    }
}

