/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class SanitizedServletResponse
extends HttpServletResponseWrapper {
    private static final boolean _X_CONTENT_TYPE_OPTIONS = GetterUtil.getBoolean(SystemProperties.get("http.header.secure.x.content.type.options"), true);
    private static final String[] _X_CONTENT_TYPE_OPTIONS_URLS_EXCLUDES = SystemProperties.getArray("http.header.secure.x.content.type.options.urls.excludes");
    private static final boolean _X_FRAME_OPTIONS;
    private static final KeyValuePair[] _xFrameOptionKVPs;

    public static HttpServletResponse getSanitizedServletResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        SanitizedServletResponse.setXContentOptions(httpServletRequest, httpServletResponse);
        SanitizedServletResponse.setXFrameOptions(httpServletRequest, httpServletResponse);
        return httpServletResponse;
    }

    public void addHeader(String name, String value) {
        super.addHeader(HttpComponentsUtil.sanitizeHeader(name), HttpComponentsUtil.sanitizeHeader(value));
    }

    public void sendRedirect(String location) throws IOException {
        super.sendRedirect(HttpComponentsUtil.sanitizeHeader(location));
    }

    public void setCharacterEncoding(String charset) {
        super.setCharacterEncoding(HttpComponentsUtil.sanitizeHeader(charset));
    }

    public void setContentType(String contentType) {
        super.setContentType(HttpComponentsUtil.sanitizeHeader(contentType));
    }

    public void setHeader(String name, String value) {
        super.setHeader(HttpComponentsUtil.sanitizeHeader(name), HttpComponentsUtil.sanitizeHeader(value));
    }

    protected static void setXContentOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (!_X_CONTENT_TYPE_OPTIONS) {
            return;
        }
        if (_X_CONTENT_TYPE_OPTIONS_URLS_EXCLUDES.length > 0) {
            String requestURI = httpServletRequest.getRequestURI();
            for (String url : _X_CONTENT_TYPE_OPTIONS_URLS_EXCLUDES) {
                if (!requestURI.startsWith(url)) continue;
                return;
            }
        }
        httpServletResponse.setHeader("X-Content-Type-Options", "nosniff");
    }

    protected static void setXFrameOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (!_X_FRAME_OPTIONS) {
            return;
        }
        String requestURI = httpServletRequest.getRequestURI();
        for (KeyValuePair xFrameOptionKVP : _xFrameOptionKVPs) {
            String url = xFrameOptionKVP.getKey();
            if (!requestURI.startsWith(url)) continue;
            String value = xFrameOptionKVP.getValue();
            if (value != null) {
                httpServletResponse.setHeader("X-Frame-Options", xFrameOptionKVP.getValue());
            }
            return;
        }
        httpServletResponse.setHeader("X-Frame-Options", "DENY");
    }

    private SanitizedServletResponse(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    static {
        String httpHeaderSecureXFrameOptionsKey = "http.header.secure.x.frame.options";
        Map<String, String> properties = SystemProperties.getProperties(httpHeaderSecureXFrameOptionsKey.concat("."), true);
        ArrayList<KeyValuePair> xFrameOptionKVPs = new ArrayList<KeyValuePair>(properties.size());
        ArrayList<String> propertyNames = new ArrayList<String>(properties.keySet());
        propertyNames.sort(Comparator.comparingInt(GetterUtil::getIntegerStrict));
        for (String propertyName : propertyNames) {
            String url;
            String propertyValue = properties.get(propertyName);
            String[] propertyValueParts = StringUtil.split(propertyValue, '|');
            if (propertyValueParts.length > 2 || Validator.isNull(url = StringUtil.trim(propertyValueParts[0]))) continue;
            if (propertyValueParts.length == 1) {
                xFrameOptionKVPs.add(new KeyValuePair(url, null));
                continue;
            }
            String value = StringUtil.trim(propertyValueParts[1]);
            if (Validator.isNull(value)) {
                value = null;
            }
            xFrameOptionKVPs.add(new KeyValuePair(url, value));
        }
        _xFrameOptionKVPs = xFrameOptionKVPs.toArray(new KeyValuePair[0]);
        _X_FRAME_OPTIONS = _xFrameOptionKVPs.length == 0 ? false : GetterUtil.getBoolean(SystemProperties.get(httpHeaderSecureXFrameOptionsKey), true);
    }
}

