/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;

public class SerializableSessionAttributeListener
implements HttpSessionAttributeListener {
    private static final Log _log = LogFactoryUtil.getLog(SerializableSessionAttributeListener.class);
    private Boolean _requiresSerializable;

    public void attributeAdded(HttpSessionBindingEvent httpSessionBindingEvent) {
        HttpSession httpSession;
        Object value = httpSessionBindingEvent.getValue();
        if (value instanceof Serializable || value == null) {
            return;
        }
        Class<?> clazz = value.getClass();
        _log.error(clazz.getName() + " is not serializable and will prevent this session from being replicated");
        if (this._requiresSerializable == null) {
            httpSession = httpSessionBindingEvent.getSession();
            ServletContext servletContext = httpSession.getServletContext();
            this._requiresSerializable = GetterUtil.getBoolean(servletContext.getInitParameter("session-attributes-requires-serializable"));
        }
        if (this._requiresSerializable.booleanValue()) {
            httpSession = httpSessionBindingEvent.getSession();
            httpSession.removeAttribute(httpSessionBindingEvent.getName());
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent httpSessionBindingEvent) {
    }

    public void attributeReplaced(HttpSessionBindingEvent httpSessionBindingEvent) {
        this.attributeAdded(httpSessionBindingEvent);
    }
}

