/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.servlet.http.HttpSession;

public class SessionMaps {
    private static final Log _log = LogFactoryUtil.getLog(SessionMaps.class);
    private final Supplier<Map<String, Object>> _mapSupplier;

    public SessionMaps(Supplier<Map<String, Object>> mapSupplier) {
        this._mapSupplier = mapSupplier;
    }

    public void add(HttpSession httpSession, String mapKey, String key, Object value) {
        this._updateMap(httpSession, mapKey, true, map -> map.put(key, value));
    }

    public void clear(HttpSession httpSession, String mapKey) {
        this._updateMap(httpSession, mapKey, false, Map::clear);
    }

    public boolean contains(HttpSession httpSession, String mapKey, String key) {
        Map<String, Object> map = this._getMap(httpSession, mapKey);
        if (map == null) {
            return false;
        }
        return map.containsKey(key);
    }

    public Object get(HttpSession httpSession, String mapKey, String key) {
        Map<String, Object> map = this._getMap(httpSession, mapKey);
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public boolean isEmpty(HttpSession httpSession, String mapKey) {
        Map<String, Object> map = this._getMap(httpSession, mapKey);
        if (map == null) {
            return true;
        }
        return map.isEmpty();
    }

    public Iterator<String> iterator(HttpSession httpSession, String mapKey) {
        Map<String, Object> map = this._getMap(httpSession, mapKey);
        if (map == null) {
            return Collections.emptyIterator();
        }
        Set<String> keySet = Collections.unmodifiableSet(map.keySet());
        return keySet.iterator();
    }

    public Set<String> keySet(HttpSession httpSession, String mapKey) {
        Map<String, Object> map = this._getMap(httpSession, mapKey);
        if (map == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(map.keySet());
    }

    public void remove(HttpSession httpSession, String mapKey, String key) {
        this._updateMap(httpSession, mapKey, false, map -> map.remove(key));
    }

    public int size(HttpSession httpSession, String mapKey) {
        Map<String, Object> map = this._getMap(httpSession, mapKey);
        if (map == null) {
            return 0;
        }
        return map.size();
    }

    private Map<String, Object> _getMap(HttpSession httpSession, String mapKey) {
        if (httpSession == null) {
            return null;
        }
        try {
            return (Map)httpSession.getAttribute(mapKey);
        }
        catch (IllegalStateException illegalStateException) {
            if (_log.isDebugEnabled()) {
                _log.debug(illegalStateException);
            }
            return null;
        }
    }

    private void _updateMap(HttpSession httpSession, String mapKey, boolean createIfAbsent, Consumer<Map<String, Object>> consumer) {
        if (httpSession == null) {
            return;
        }
        Map<String, Object> map = this._getMap(httpSession, mapKey);
        if (map == null) {
            if (!createIfAbsent) {
                return;
            }
            map = this._mapSupplier.get();
        }
        consumer.accept(map);
        httpSession.setAttribute(mapKey, map);
    }
}

