/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.filters.invoker;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.servlet.LiferayFilter;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.servlet.filters.invoker.Dispatcher;
import com.liferay.portal.kernel.servlet.filters.invoker.FilterMapping;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilter;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilterChain;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilterConfig;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class InvokerFilterHelper {
    private static final Log _log = LogFactoryUtil.getLog(InvokerFilterHelper.class);
    private final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private final ConcurrentMap<String, FilterMapping[]> _filterMappingsMap = new ConcurrentHashMap<String, FilterMapping[]>();
    private final List<String> _filterNames = new CopyOnWriteArrayList<String>();
    private final List<InvokerFilter> _invokerFilters = new ArrayList<InvokerFilter>();
    private ServiceTracker<Filter, FilterMapping> _serviceTracker;

    public void clearFilterChainsCache() {
        for (InvokerFilter invokerFilter : this._invokerFilters) {
            invokerFilter.clearFilterChainsCache();
        }
    }

    public void destroy() {
        this._serviceTracker.close();
        for (FilterMapping[] filterMappings : this._filterMappingsMap.values()) {
            FilterMapping filterMapping = filterMappings[0];
            Filter filter = filterMapping.getFilter();
            try {
                filter.destroy();
            }
            catch (Exception exception) {
                _log.error(exception);
            }
        }
        this._filterMappingsMap.clear();
        this._filterNames.clear();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            ServletContext servletContext = filterConfig.getServletContext();
            this.readLiferayFilterWebXML(servletContext, "/WEB-INF/liferay-web.xml");
            String servletContextName = GetterUtil.getString(servletContext.getServletContextName());
            String portalServletContextName = PortalUtil.getServletContextName();
            if (servletContextName.equals(portalServletContextName)) {
                servletContextName = "";
            }
            this._serviceTracker = new ServiceTracker(this._bundleContext, SystemBundleUtil.createFilter(StringBundler.concat((String[])new String[]{"(&(objectClass=", Filter.class.getName(), ")(servlet-context-name=", servletContextName, ")(servlet-filter-name=*))"})), (ServiceTrackerCustomizer)new FilterServiceTrackerCustomizer());
            this._serviceTracker.open();
        }
        catch (Exception exception) {
            _log.error(exception);
            throw new ServletException((Throwable)exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerFilterMapping(FilterMapping filterMapping, String positionFilterName, boolean after) {
        String filterName = filterMapping.getFilterName();
        while (true) {
            FilterMapping[] oldFilterMappings = (FilterMapping[])this._filterMappingsMap.get(filterName);
            FilterMapping[] newFilterMappings = null;
            if (oldFilterMappings == null) {
                newFilterMappings = new FilterMapping[]{filterMapping};
            } else {
                newFilterMappings = Arrays.copyOf(oldFilterMappings, oldFilterMappings.length + 1);
                newFilterMappings[oldFilterMappings.length] = filterMapping;
            }
            if (newFilterMappings.length == 1) {
                FilterMapping[] filterMappings = this._filterMappingsMap.putIfAbsent(filterName, newFilterMappings);
                if (filterMappings != null) continue;
                int index = this._filterNames.indexOf(positionFilterName);
                if (index == -1) {
                    this._filterNames.add(filterName);
                    return;
                }
                if (after) {
                    this._filterNames.add(index + 1, filterName);
                    return;
                }
                this._filterNames.add(index, filterName);
                return;
            }
            if (this._filterMappingsMap.replace(filterName, oldFilterMappings, newFilterMappings)) return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unregisterFilterMapping(FilterMapping filterMapping) {
        String filterName = filterMapping.getFilterName();
        while (true) {
            FilterMapping[] oldFilterMappings;
            FilterMapping[] newFilterMappings;
            if ((newFilterMappings = ArrayUtil.remove(oldFilterMappings = (FilterMapping[])this._filterMappingsMap.get(filterName), filterMapping)).length == 0) {
                if (!this._filterMappingsMap.remove(filterName, oldFilterMappings)) continue;
                this._filterNames.remove(filterName);
                return;
            }
            if (this._filterMappingsMap.replace(filterName, oldFilterMappings, newFilterMappings)) return;
        }
    }

    public void unregisterFilterMappings(String filterName) {
        FilterMapping[] filterMappings = (FilterMapping[])this._filterMappingsMap.remove(filterName);
        if (filterMappings == null) {
            return;
        }
        FilterMapping filterMapping = filterMappings[0];
        Filter filter = filterMapping.getFilter();
        if (filter != null) {
            try {
                filter.destroy();
            }
            catch (Exception exception) {
                _log.error(exception);
            }
        }
        this._filterNames.remove(filterName);
        this.clearFilterChainsCache();
    }

    public void updateFilterMappings(String filterName, Filter filter) {
        FilterMapping[] newFilterMappings;
        FilterMapping[] oldFilterMappings;
        do {
            if ((oldFilterMappings = (FilterMapping[])this._filterMappingsMap.get(filterName)) == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn("No filter mappings for filter name " + filterName);
                }
                return;
            }
            newFilterMappings = new FilterMapping[oldFilterMappings.length];
            for (int i = 0; i < oldFilterMappings.length; ++i) {
                newFilterMappings[i] = oldFilterMappings[i].replaceFilter(filter);
            }
        } while (!this._filterMappingsMap.replace(filterName, oldFilterMappings, newFilterMappings));
    }

    protected void addInvokerFilter(InvokerFilter invokerFilter) {
        this._invokerFilters.add(invokerFilter);
    }

    protected InvokerFilterChain createInvokerFilterChain(HttpServletRequest httpServletRequest, Dispatcher dispatcher, String uri, FilterChain filterChain) {
        InvokerFilterChain invokerFilterChain = new InvokerFilterChain(filterChain);
        for (String filterName : this._filterNames) {
            FilterMapping[] filterMappings = (FilterMapping[])this._filterMappingsMap.get(filterName);
            if (filterMappings == null) continue;
            for (FilterMapping filterMapping : filterMappings) {
                LiferayFilter liferayFilter;
                Filter filter;
                if (!filterMapping.isMatch(httpServletRequest, dispatcher, uri) || (filter = filterMapping.getFilter()) instanceof LiferayFilter && !(liferayFilter = (LiferayFilter)filter).isFilterEnabled()) continue;
                invokerFilterChain.addFilter(filter);
            }
        }
        return invokerFilterChain;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Filter initFilter(ServletContext servletContext, String filterClassName, FilterConfig filterConfig) {
        ClassLoader portalClassLoader;
        ClassLoader pluginClassLoader = (ClassLoader)servletContext.getAttribute("PLUGIN_CLASS_LOADER");
        if (pluginClassLoader == null) {
            Thread currentThread = Thread.currentThread();
            pluginClassLoader = currentThread.getContextClassLoader();
        }
        if ((portalClassLoader = PortalClassLoaderUtil.getClassLoader()) != pluginClassLoader) {
            pluginClassLoader = AggregateClassLoader.getAggregateClassLoader(portalClassLoader, pluginClassLoader);
        }
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)pluginClassLoader);){
            Filter filter2 = (Filter)InstanceFactory.newInstance(pluginClassLoader, filterClassName);
            filter2.init(filterConfig);
            Filter filter = filter2;
            return filter;
        }
        catch (Exception exception) {
            _log.error("Unable to initialize filter " + filterClassName, exception);
            return null;
        }
    }

    protected void readLiferayFilterWebXML(ServletContext servletContext, String path) throws Exception {
        InputStream inputStream = servletContext.getResourceAsStream(path);
        if (inputStream == null) {
            return;
        }
        Document document = UnsecureSAXReaderUtil.read(inputStream, true);
        Element rootElement = document.getRootElement();
        HashMap<String, ObjectValuePair<Filter, Object>> filterObjectValuePairs = new HashMap<String, ObjectValuePair<Filter, Object>>();
        for (Element filterElement : rootElement.elements("filter")) {
            String filterName = filterElement.elementText("filter-name");
            String filterClassName = filterElement.elementText("filter-class");
            HashMap<String, String> initParameterMap = new HashMap<String, String>();
            List<Element> initParamElements = filterElement.elements("init-param");
            for (Element initParamElement : initParamElements) {
                String name = initParamElement.elementText("param-name");
                String value = initParamElement.elementText("param-value");
                initParameterMap.put(name, value);
            }
            InvokerFilterConfig filterConfig = new InvokerFilterConfig(servletContext, filterName, initParameterMap);
            Filter filter = this.initFilter(servletContext, filterClassName, filterConfig);
            if (filter == null) continue;
            filterObjectValuePairs.put(filterName, new ObjectValuePair<Filter, Object>(filter, filterConfig));
        }
        List<Element> filterMappingElements = rootElement.elements("filter-mapping");
        for (Element filterMappingElement : filterMappingElements) {
            String filterName = filterMappingElement.elementText("filter-name");
            ArrayList<String> urlPatterns = new ArrayList<String>();
            List<Element> urlPatternElements = filterMappingElement.elements("url-pattern");
            for (Element urlPatternElement : urlPatternElements) {
                urlPatterns.add(urlPatternElement.getTextTrim());
            }
            HashSet<Dispatcher> dispatchers = new HashSet<Dispatcher>();
            List<Element> dispatcherElements = filterMappingElement.elements("dispatcher");
            for (Element dispatcherElement : dispatcherElements) {
                String dispatcher = StringUtil.toUpperCase(dispatcherElement.getTextTrim());
                dispatchers.add(Dispatcher.valueOf(dispatcher));
            }
            ObjectValuePair filterObjectValuePair = (ObjectValuePair)filterObjectValuePairs.get(filterName);
            if (filterObjectValuePair == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn("No filter and filter config for filter name " + filterName);
                continue;
            }
            FilterMapping filterMapping = new FilterMapping(filterName, (Filter)filterObjectValuePair.getKey(), (FilterConfig)filterObjectValuePair.getValue(), urlPatterns, dispatchers);
            this.registerFilterMapping(filterMapping, null, true);
        }
    }

    private class FilterServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Filter, FilterMapping> {
        private FilterServiceTrackerCustomizer() {
        }

        public FilterMapping addingService(ServiceReference<Filter> serviceReference) {
            String beforeFilter;
            Filter filter = (Filter)InvokerFilterHelper.this._bundleContext.getService(serviceReference);
            String servletContextName = GetterUtil.getString(serviceReference.getProperty("servlet-context-name"));
            if (Validator.isBlank(servletContextName)) {
                servletContextName = PortalUtil.getServletContextName();
            }
            String positionFilterName = beforeFilter = GetterUtil.getString(serviceReference.getProperty("before-filter"));
            boolean after = false;
            String afterFilter = GetterUtil.getString(serviceReference.getProperty("after-filter"));
            if (Validator.isNotNull(afterFilter)) {
                positionFilterName = afterFilter;
                after = true;
            }
            HashMap<String, String> initParameterMap = new HashMap<String, String>();
            for (String key : serviceReference.getPropertyKeys()) {
                if (!key.startsWith("init-param.")) continue;
                String value = GetterUtil.getString(serviceReference.getProperty(key));
                initParameterMap.put(StringUtil.removeSubstring(key, "init-param."), value);
            }
            ServletContext servletContext = ServletContextPool.get(servletContextName);
            String servletFilterName = GetterUtil.getString(serviceReference.getProperty("servlet-filter-name"));
            InvokerFilterConfig filterConfig = new InvokerFilterConfig(servletContext, servletFilterName, initParameterMap);
            try {
                filter.init((FilterConfig)filterConfig);
            }
            catch (ServletException servletException) {
                _log.error(servletException);
                InvokerFilterHelper.this._bundleContext.ungetService(serviceReference);
                return null;
            }
            InvokerFilterHelper.this.updateFilterMappings(servletFilterName, filter);
            HashSet<Dispatcher> dispatchers = new HashSet<Dispatcher>();
            for (String dispatcherString : StringUtil.asList(serviceReference.getProperty("dispatcher"))) {
                dispatchers.add(Dispatcher.valueOf(dispatcherString));
            }
            FilterMapping filterMapping = new FilterMapping(servletFilterName, filter, filterConfig, StringUtil.asList(serviceReference.getProperty("url-pattern")), dispatchers);
            InvokerFilterHelper.this.registerFilterMapping(filterMapping, positionFilterName, after);
            InvokerFilterHelper.this.clearFilterChainsCache();
            return filterMapping;
        }

        public void modifiedService(ServiceReference<Filter> serviceReference, FilterMapping filterMapping) {
            this.removedService(serviceReference, filterMapping);
            this.addingService((ServiceReference)serviceReference);
        }

        public void removedService(ServiceReference<Filter> serviceReference, FilterMapping filterMapping) {
            InvokerFilterHelper.this._bundleContext.ungetService(serviceReference);
            InvokerFilterHelper.this.unregisterFilterMappings(GetterUtil.getString(serviceReference.getProperty("servlet-filter-name")));
        }
    }
}

