/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.theme;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class NavItem
implements Serializable {
    private List<NavItem> _browsableChildren;
    private List<NavItem> _children;
    private final HttpServletRequest _httpServletRequest;
    private final Layout _layout;
    private final ThemeDisplay _themeDisplay;

    public static List<NavItem> fromLayouts(HttpServletRequest httpServletRequest, List<Layout> parentLayouts, ThemeDisplay themeDisplay) throws PortalException {
        if (parentLayouts == null) {
            return Collections.emptyList();
        }
        Map<Long, List<Layout>> layoutChildLayouts = LayoutLocalServiceUtil.getLayoutChildLayouts(parentLayouts);
        for (List<Layout> childLayouts : layoutChildLayouts.values()) {
            Iterator<Layout> iterator = childLayouts.iterator();
            while (iterator.hasNext()) {
                Layout childLayout = iterator.next();
                if (!NavItem._isContentLayoutDraft(childLayout) && NavItem._isLayoutRevisionDisplayable(childLayout) && !childLayout.isHidden() && LayoutPermissionUtil.contains(themeDisplay.getPermissionChecker(), childLayout, "VIEW")) continue;
                iterator.remove();
            }
        }
        ArrayList<NavItem> navItems = new ArrayList<NavItem>(parentLayouts.size());
        for (Layout parentLayout : parentLayouts) {
            List<Layout> childLayouts = layoutChildLayouts.get(parentLayout.getPlid());
            if (NavItem._isContentLayoutDraft(parentLayout) || !NavItem._isLayoutRevisionDisplayable(parentLayout)) continue;
            navItems.add(new NavItem(httpServletRequest, themeDisplay, parentLayout, childLayouts));
        }
        return navItems;
    }

    public NavItem(HttpServletRequest httpServletRequest, Layout layout) {
        this(httpServletRequest, (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY"), layout);
    }

    public NavItem(HttpServletRequest httpServletRequest, ThemeDisplay themeDisplay, Layout layout) {
        this._httpServletRequest = httpServletRequest;
        this._themeDisplay = themeDisplay;
        this._layout = layout;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NavItem)) {
            return false;
        }
        NavItem navItem = (NavItem)object;
        return this.getLayoutId() == navItem.getLayoutId();
    }

    public List<NavItem> getBrowsableChildren() throws Exception {
        if (this._browsableChildren == null) {
            this._browsableChildren = ListUtil.filter(this.getChildren(), NavItem::isBrowsable);
        }
        return this._browsableChildren;
    }

    public List<NavItem> getChildren() throws Exception {
        if (this._children == null) {
            List<Layout> layouts = this._layout.getChildren(this._themeDisplay.getPermissionChecker());
            this._children = this._fromLayouts(this._httpServletRequest, this._themeDisplay, layouts);
        }
        return this._children;
    }

    public Map<String, Serializable> getExpandoAttributes() {
        ExpandoBridge expandoBridge;
        if (this._layout != null && (expandoBridge = this._layout.getExpandoBridge()) != null) {
            return expandoBridge.getAttributes();
        }
        return new HashMap<String, Serializable>();
    }

    public Layout getLayout() {
        return this._layout;
    }

    public long getLayoutId() {
        return this._layout.getLayoutId();
    }

    public String getName() {
        return HtmlUtil.escape(this.getUnescapedName());
    }

    public String getRegularFullURL() throws Exception {
        String portalURL = this._themeDisplay.getPortalURL();
        String regularURL = this.getRegularURL();
        if (StringUtil.startsWith(regularURL, portalURL) || Validator.isUrl(regularURL)) {
            return regularURL;
        }
        return portalURL.concat(regularURL);
    }

    public String getRegularURL() throws Exception {
        return this._layout.getRegularURL(this._httpServletRequest);
    }

    public String getResetLayoutURL() throws Exception {
        return this._layout.getResetLayoutURL(this._httpServletRequest);
    }

    public String getResetMaxStateURL() throws Exception {
        return this._layout.getResetMaxStateURL(this._httpServletRequest);
    }

    public String getTarget() {
        return this._layout.getTarget();
    }

    public String getTitle() {
        return this._layout.getTitle(this._themeDisplay.getLanguageId());
    }

    public String getUnescapedName() {
        return this._layout.getName(this._themeDisplay.getLanguageId());
    }

    public String getURL() throws Exception {
        return HtmlUtil.escapeHREF(this.getRegularFullURL());
    }

    public boolean hasBrowsableChildren() throws Exception {
        List<NavItem> browsableChildren = this.getBrowsableChildren();
        return !browsableChildren.isEmpty();
    }

    public boolean hasChildren() throws Exception {
        List<NavItem> children = this.getChildren();
        return !children.isEmpty();
    }

    public int hashCode() {
        return this._layout.hashCode();
    }

    public String iconURL() throws Exception {
        if (this._layout == null || !this._layout.isIconImage()) {
            return "";
        }
        return StringBundler.concat((Object[])new Object[]{this._themeDisplay.getPathImage(), "/layout_icon?img_id=", this._layout.getIconImageId(), "&t=", WebServerServletTokenUtil.getToken(this._layout.getIconImageId())});
    }

    public boolean isBrowsable() {
        LayoutType layoutType = this._layout.getLayoutType();
        return layoutType.isBrowsable();
    }

    public boolean isChildSelected() throws PortalException {
        return this._layout.isChildSelected(this._themeDisplay.isTilesSelectable(), this._themeDisplay.getLayout());
    }

    public boolean isInNavigation(List<NavItem> navItems) {
        if (navItems == null) {
            return false;
        }
        return navItems.contains(this);
    }

    public boolean isSelected() throws Exception {
        Layout layout = this._themeDisplay.getLayout();
        return this._layout.isSelected(this._themeDisplay.isTilesSelectable(), this._themeDisplay.getLayout(), layout.getAncestorPlid());
    }

    private static boolean _isContentLayoutDraft(Layout layout) {
        if (!layout.isTypeContent()) {
            return false;
        }
        if (layout.fetchDraftLayout() != null) {
            return !layout.isPublished();
        }
        return !layout.isApproved() || layout.isHidden() || layout.isSystem();
    }

    private static boolean _isLayoutRevisionDisplayable(Layout layout) {
        if (layout.isTypeContent() || !LayoutStagingUtil.isBranchingLayout(layout)) {
            return true;
        }
        LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision(layout);
        if (!layoutRevision.isIncomplete()) {
            return true;
        }
        LayoutType layoutType = layout.getLayoutType();
        LayoutTypeController layoutTypeController = layoutType.getLayoutTypeController();
        return layoutTypeController.isWorkflowEnabled();
    }

    private NavItem(HttpServletRequest httpServletRequest, ThemeDisplay themeDisplay, Layout layout, List<Layout> childLayouts) {
        this._httpServletRequest = httpServletRequest;
        this._themeDisplay = themeDisplay;
        this._layout = layout;
        this._children = this._fromLayouts(httpServletRequest, themeDisplay, childLayouts);
    }

    private List<NavItem> _fromLayouts(HttpServletRequest httpServletRequest, ThemeDisplay themeDisplay, List<Layout> layouts) {
        if (ListUtil.isEmpty(layouts)) {
            return Collections.emptyList();
        }
        ArrayList<NavItem> navItems = new ArrayList<NavItem>(layouts.size());
        for (Layout layout : layouts) {
            navItems.add(new NavItem(httpServletRequest, themeDisplay, layout));
        }
        return navItems;
    }
}

