/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.transaction;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.transaction.NewTransactionLifecycleListener;
import com.liferay.portal.kernel.transaction.TransactionAttribute;
import com.liferay.portal.kernel.transaction.TransactionLifecycleListener;
import com.liferay.portal.kernel.transaction.TransactionStatus;
import org.osgi.framework.BundleContext;

public class TransactionLifecycleNotifier {
    public static final TransactionLifecycleListener TRANSACTION_LIFECYCLE_LISTENER = new NewTransactionLifecycleListener(){

        @Override
        protected void doCommitted(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
            TransactionLifecycleNotifier.fireTransactionCommittedEvent(transactionAttribute, transactionStatus);
        }

        @Override
        protected void doCreated(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
            TransactionLifecycleNotifier.fireTransactionCreatedEvent(transactionAttribute, transactionStatus);
        }

        @Override
        protected void doRollbacked(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus, Throwable throwable) {
            TransactionLifecycleNotifier.fireTransactionRollbackedEvent(transactionAttribute, transactionStatus, throwable);
        }
    };
    private static final ServiceTrackerList<TransactionLifecycleListener> _transactionLifecycleListeners = ServiceTrackerListFactory.open((BundleContext)SystemBundleUtil.getBundleContext(), TransactionLifecycleListener.class);

    protected static void fireTransactionCommittedEvent(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
        for (TransactionLifecycleListener transactionLifecycleListener : _transactionLifecycleListeners) {
            transactionLifecycleListener.committed(transactionAttribute, transactionStatus);
        }
    }

    protected static void fireTransactionCreatedEvent(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
        for (TransactionLifecycleListener transactionLifecycleListener : _transactionLifecycleListeners) {
            transactionLifecycleListener.created(transactionAttribute, transactionStatus);
        }
    }

    protected static void fireTransactionRollbackedEvent(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus, Throwable throwable) {
        for (TransactionLifecycleListener transactionLifecycleListener : _transactionLifecycleListeners) {
            transactionLifecycleListener.rollbacked(transactionAttribute, transactionStatus, throwable);
        }
    }

    private TransactionLifecycleNotifier() {
    }
}

