/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Map;

public class BaseSQLServerDatetimeUpgradeProcess
extends UpgradeProcess {
    private static final int _NEW_SIZE = 6;
    private static final String _NEW_TYPE = "datetime2";
    private static final Log _log = LogFactoryUtil.getLog(BaseSQLServerDatetimeUpgradeProcess.class);
    private final Class<?>[] _tableClasses;

    public BaseSQLServerDatetimeUpgradeProcess(Class<?>[] tableClasses) {
        this._tableClasses = tableClasses;
    }

    @Override
    protected void doUpgrade() throws Exception {
        if (DBManagerUtil.getDBType() != DBType.SQLSERVER) {
            return;
        }
        for (Class<?> tableClass : this._tableClasses) {
            this._upgradeTable(tableClass);
        }
    }

    private void _upgradeTable(Class<?> tableClass) throws Exception {
        DBInspector dbInspector = new DBInspector(this.connection);
        String catalog = dbInspector.getCatalog();
        String schema = dbInspector.getSchema();
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        String tableName = dbInspector.normalizeName(this.getTableName(tableClass), databaseMetaData);
        try (ResultSet tableResultSet = databaseMetaData.getTables(catalog, schema, tableName, null);){
            if (!tableResultSet.next()) {
                _log.error(StringBundler.concat((String[])new String[]{"Table ", tableName, " does not exist"}));
                return;
            }
            String newTypeName = dbInspector.normalizeName(_NEW_TYPE);
            String newTypeDefinition = StringBundler.concat((Object[])new Object[]{newTypeName, "(", 6, ")"});
            Map<String, Integer> tableColumnsMap = this.getTableColumnsMap(tableClass);
            for (Map.Entry<String, Integer> entry : tableColumnsMap.entrySet()) {
                if (entry.getValue() != 93) continue;
                String columnName = dbInspector.normalizeName(entry.getKey(), databaseMetaData);
                ResultSet columnResultSet = databaseMetaData.getColumns(null, null, tableName, columnName);
                Throwable throwable = null;
                try {
                    if (!columnResultSet.next()) {
                        _log.error(StringBundler.concat((String[])new String[]{"Column ", columnName, " does not exist in table ", tableName}));
                        continue;
                    }
                    if (newTypeName.equals(columnResultSet.getString("TYPE_NAME")) && 6 == columnResultSet.getInt("DECIMAL_DIGITS")) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn(StringBundler.concat((String[])new String[]{"Column ", columnName, " in table ", tableName, " already is ", newTypeDefinition}));
                        continue;
                    }
                    this.alterColumnType(tableName, columnName, newTypeDefinition);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (columnResultSet == null) continue;
                    if (throwable != null) {
                        try {
                            columnResultSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    columnResultSet.close();
                }
            }
        }
    }
}

