/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.util.Arrays;

public class UpgradeProcessFactory {
    public static UpgradeProcess addColumns(final String tableName, final String ... columnDefinitions) {
        return new UpgradeProcess(UpgradeProcessFactory._getUpgradeInfo(tableName, "add the columns " + Arrays.toString(columnDefinitions))){

            @Override
            protected void doUpgrade() throws Exception {
                for (String columnDefinition : columnDefinitions) {
                    this.alterTableAddColumn(tableName, columnDefinition.substring(0, columnDefinition.indexOf(" ")), columnDefinition.substring(columnDefinition.indexOf(" ") + 1));
                }
            }
        };
    }

    public static UpgradeProcess alterColumnName(final String tableName, final String oldColumnName, final String newColumnDefinition) {
        return new UpgradeProcess(UpgradeProcessFactory._getUpgradeInfo(tableName, StringBundler.concat((String[])new String[]{"alter the name of the column ", oldColumnName, " to ", newColumnDefinition}))){

            @Override
            protected void doUpgrade() throws Exception {
                this.alterColumnName(tableName, oldColumnName, newColumnDefinition);
            }
        };
    }

    public static UpgradeProcess alterColumnType(final String tableName, final String columnName, final String newColumnType) {
        return new UpgradeProcess(UpgradeProcessFactory._getUpgradeInfo(tableName, StringBundler.concat((String[])new String[]{"alter the type of the column ", columnName, " to ", newColumnType}))){

            @Override
            protected void doUpgrade() throws Exception {
                this.alterColumnType(tableName, columnName, newColumnType);
            }
        };
    }

    public static UpgradeProcess dropColumns(final String tableName, final String ... columnNames) {
        return new UpgradeProcess(UpgradeProcessFactory._getUpgradeInfo(tableName, "drop the columns " + Arrays.toString(columnNames))){

            @Override
            protected void doUpgrade() throws Exception {
                for (String columnName : columnNames) {
                    this.alterTableDropColumn(tableName, columnName);
                }
            }
        };
    }

    public static UpgradeProcess dropTables(final String ... tableNames) {
        return new UpgradeProcess(UpgradeProcessFactory._getUpgradeInfo("drop tables " + Arrays.toString(tableNames))){

            @Override
            protected void doUpgrade() throws Exception {
                for (String tableName : tableNames) {
                    this.dropTable(tableName);
                }
            }
        };
    }

    public static UpgradeProcess runSQL(final String ... sqls) {
        return new UpgradeProcess(UpgradeProcessFactory._getUpgradeInfo("run SQL updates")){

            @Override
            protected void doUpgrade() throws Exception {
                for (String sql : sqls) {
                    this.runSQL(sql);
                }
            }
        };
    }

    private static String _getUpgradeInfo(String message) {
        return UpgradeProcessFactory._getUpgradeInfo(null, "Modifying schema to " + message);
    }

    private static String _getUpgradeInfo(String tableName, String message) {
        Thread thread = Thread.currentThread();
        String callerClassName = thread.getStackTrace()[3].getClassName();
        if (tableName == null) {
            return callerClassName + " - " + message;
        }
        return StringBundler.concat((String[])new String[]{callerClassName, " - Modifying table ", tableName, " to ", message});
    }
}

