/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.webcache;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.webcache.WebCacheException;
import com.liferay.portal.kernel.webcache.WebCacheItem;

public class WebCachePoolUtil {
    private static final String _CACHE_NAME = WebCachePoolUtil.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(WebCachePoolUtil.class);
    private static final PortalCache<String, Object> _portalCache = PortalCacheHelperUtil.getPortalCache("SINGLE_VM_PORTAL_CACHE_MANAGER", _CACHE_NAME);

    public static void clear() {
        _portalCache.removeAll();
    }

    public static Object get(String key, WebCacheItem webCacheItem) {
        Object object;
        block6: {
            object = _portalCache.get(key);
            if (object != null) {
                return object;
            }
            try {
                object = webCacheItem.convert(key);
                if (object == null) {
                    return null;
                }
                int timeToLive = (int)(webCacheItem.getRefreshTime() / 1000L);
                if (timeToLive > 0) {
                    _portalCache.put(key, object, timeToLive);
                }
            }
            catch (WebCacheException webCacheException) {
                if (!_log.isWarnEnabled()) break block6;
                Throwable throwable = webCacheException.getCause();
                if (throwable != null) {
                    _log.warn(throwable, throwable);
                }
                _log.warn(webCacheException);
            }
        }
        return object;
    }

    public static void remove(String key) {
        _portalCache.remove(key);
    }
}

