/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.webdav;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.GroupFriendlyURLComparator;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class WebDAVUtil {
    public static final Namespace DAV_URI = SAXReaderUtil.createNamespace("D", "DAV:");
    public static final int SC_LOCKED = 423;
    public static final int SC_MULTI_STATUS = 207;
    public static final String TOKEN_PREFIX = "opaquelocktoken:";
    private static final String _TIME_PREFIX = "Second-";
    private static final Log _log = LogFactoryUtil.getLog(WebDAVUtil.class);
    private static final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private static final ServiceTrackerMap<String, WebDAVStorage> _storages = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)_bundleContext, WebDAVStorage.class, (String)"webdav.storage.token", (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<WebDAVStorage, WebDAVStorage>(){

        public WebDAVStorage addingService(ServiceReference<WebDAVStorage> serviceReference) {
            WebDAVStorage webDAVStorage = (WebDAVStorage)_bundleContext.getService(serviceReference);
            this.setToken(serviceReference, webDAVStorage);
            return webDAVStorage;
        }

        public void modifiedService(ServiceReference<WebDAVStorage> serviceReference, WebDAVStorage webDAVStorage) {
            this.setToken(serviceReference, webDAVStorage);
        }

        public void removedService(ServiceReference<WebDAVStorage> serviceReference, WebDAVStorage webDAVStorage) {
            _bundleContext.ungetService(serviceReference);
        }

        protected void setToken(ServiceReference<WebDAVStorage> serviceReference, WebDAVStorage webDAVStorage) {
            String token = (String)serviceReference.getProperty("webdav.storage.token");
            webDAVStorage.setToken(token);
        }
    });

    public static Namespace createNamespace(String prefix, String uri) {
        Namespace namespace = null;
        namespace = uri.equals(DAV_URI.getURI()) ? DAV_URI : (Validator.isNull(prefix) ? SAXReaderUtil.createNamespace(uri) : SAXReaderUtil.createNamespace(prefix, uri));
        return namespace;
    }

    public static long getDepth(HttpServletRequest httpServletRequest) {
        String value = GetterUtil.getString(httpServletRequest.getHeader("Depth"));
        if (_log.isDebugEnabled()) {
            _log.debug("\"Depth\" header is " + value);
        }
        if (value.equals("0")) {
            return 0L;
        }
        return -1L;
    }

    public static String getDestination(HttpServletRequest httpServletRequest, String rootPath) {
        String headerDestination = httpServletRequest.getHeader("Destination");
        String[] pathSegments = StringUtil.split(headerDestination, rootPath);
        String destination = pathSegments[pathSegments.length - 1];
        destination = HttpComponentsUtil.decodePath(destination);
        if (_log.isDebugEnabled()) {
            _log.debug("Destination " + destination);
        }
        return destination;
    }

    public static long getGroupId(long companyId, String path) throws WebDAVException {
        return WebDAVUtil.getGroupId(companyId, WebDAVUtil.getPathArray(path));
    }

    public static long getGroupId(long companyId, String[] pathArray) throws WebDAVException {
        try {
            if (pathArray.length == 0) {
                return 0L;
            }
            String name = pathArray[0];
            Group group = GroupLocalServiceUtil.fetchFriendlyURLGroup(companyId, "/" + name);
            if (group != null) {
                return group.getGroupId();
            }
            User user = UserLocalServiceUtil.fetchUserByScreenName(companyId, name);
            if (user != null) {
                group = user.getGroup();
                return group.getGroupId();
            }
        }
        catch (Exception exception) {
            throw new WebDAVException(exception);
        }
        return 0L;
    }

    public static List<Group> getGroups(long userId) throws Exception {
        return WebDAVUtil.getGroups(UserLocalServiceUtil.getUser(userId));
    }

    public static List<Group> getGroups(User user) throws Exception {
        if (user.isGuestUser()) {
            return ListUtil.fromArray(GroupLocalServiceUtil.getGroup(user.getCompanyId(), "Guest"));
        }
        HashSet<Group> groups = new HashSet<Group>();
        GroupFriendlyURLComparator orderByComparator = GroupFriendlyURLComparator.getInstance(true);
        groups.addAll(GroupLocalServiceUtil.search(user.getCompanyId(), null, null, LinkedHashMapBuilder.put("usersGroups", Long.valueOf(user.getUserId())).build(), -1, -1, (OrderByComparator<Group>)orderByComparator));
        groups.addAll(GroupLocalServiceUtil.getUserOrganizationsGroups(user.getUserId(), -1, -1));
        if (!user.isGuestUser()) {
            groups.add(user.getGroup());
        }
        ArrayList<Group> groupsList = new ArrayList<Group>(groups);
        Collections.sort(groupsList, orderByComparator);
        return groupsList;
    }

    public static String getLockUuid(HttpServletRequest httpServletRequest) throws WebDAVException {
        String value = GetterUtil.getString(httpServletRequest.getHeader("If"));
        if (_log.isDebugEnabled()) {
            _log.debug("\"If\" header is " + value);
        }
        if (value.contains("(<DAV:no-lock>)")) {
            if (_log.isWarnEnabled()) {
                _log.warn("Lock tokens can never be <DAV:no-lock>");
            }
            throw new WebDAVException();
        }
        String token = "";
        int beg = value.indexOf(TOKEN_PREFIX);
        if (beg >= 0 && (beg += TOKEN_PREFIX.length()) < value.length()) {
            int end = value.indexOf(62, beg);
            token = GetterUtil.getString(value.substring(beg, end));
        }
        return token;
    }

    public static String[] getPathArray(String path) {
        return WebDAVUtil.getPathArray(path, false);
    }

    public static String[] getPathArray(String path, boolean fixTrailing) {
        path = HttpComponentsUtil.fixPath(path, true, fixTrailing);
        return StringUtil.split(path, '/');
    }

    public static String getResourceName(String[] pathArray) {
        if (pathArray.length <= 2) {
            return "";
        }
        return pathArray[pathArray.length - 1];
    }

    public static WebDAVStorage getStorage(String token) {
        return (WebDAVStorage)_storages.getService((Object)token);
    }

    public static String getStorageToken(Portlet portlet) {
        WebDAVStorage webDAVStorageInstance = portlet.getWebDAVStorageInstance();
        if (webDAVStorageInstance == null) {
            return null;
        }
        return webDAVStorageInstance.getToken();
    }

    public static Collection<String> getStorageTokens() {
        return _storages.keySet();
    }

    public static long getTimeout(HttpServletRequest httpServletRequest) {
        int index;
        long timeout = 0L;
        String value = GetterUtil.getString(httpServletRequest.getHeader("Timeout"));
        if (_log.isDebugEnabled()) {
            _log.debug("\"Timeout\" header is " + value);
        }
        if ((index = value.indexOf(_TIME_PREFIX)) >= 0 && (index += _TIME_PREFIX.length()) < value.length()) {
            timeout = GetterUtil.getLong(value.substring(index));
        }
        return timeout * 1000L;
    }

    public static boolean isOverwrite(HttpServletRequest httpServletRequest) {
        String value = GetterUtil.getString(httpServletRequest.getHeader("Overwrite"));
        return !StringUtil.equalsIgnoreCase(value, "F") && GetterUtil.getBoolean(value);
    }

    public static String stripManualCheckInRequiredPath(String url) {
        return WebDAVUtil.stripToken(url, "/manualCheckInRequired");
    }

    public static String stripOfficeExtension(String url) {
        String strippedUrl = WebDAVUtil.stripToken(url, "/officeExtension");
        if (strippedUrl.length() != url.length()) {
            strippedUrl = FileUtil.stripExtension(strippedUrl);
        }
        return strippedUrl;
    }

    public static String stripToken(String url, String token) {
        if (Validator.isNull(url)) {
            return "";
        }
        int index = url.indexOf(token);
        if (index >= 0) {
            url = url.substring(0, index) + url.substring(index + token.length());
        }
        return url;
    }
}

