/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.workflow;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.model.WorkflowInstanceLink;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalServiceUtil;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class WorkflowHandlerRegistryUtil {
    private static final Log _log = LogFactoryUtil.getLog(WorkflowHandlerRegistryUtil.class);
    private static final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private static final ServiceTrackerMap<String, WorkflowHandler<?>> _scopeableWorkflowHandlerServiceTrackerMap;
    private static final ServiceTrackerMap<String, WorkflowHandler<?>> _workflowHandlerServiceTrackerMap;

    public static List<WorkflowHandler<?>> getScopeableWorkflowHandlers() {
        return WorkflowHandlerRegistryUtil._getWorkflowHandlers(_scopeableWorkflowHandlerServiceTrackerMap);
    }

    public static <T> WorkflowHandler<T> getWorkflowHandler(String className) {
        return (WorkflowHandler)_workflowHandlerServiceTrackerMap.getService((Object)className);
    }

    public static List<WorkflowHandler<?>> getWorkflowHandlers() {
        return WorkflowHandlerRegistryUtil._getWorkflowHandlers(_workflowHandlerServiceTrackerMap);
    }

    public static <T> void startWorkflowInstance(long companyId, long groupId, long userId, String className, long classPK, T model, ServiceContext serviceContext) throws PortalException {
        Map<String, Serializable> workflowContext = (Map<String, Serializable>)((Object)serviceContext.removeAttribute("workflowContext"));
        if (workflowContext == null) {
            workflowContext = Collections.emptyMap();
        }
        WorkflowHandlerRegistryUtil.startWorkflowInstance(companyId, groupId, userId, className, classPK, model, serviceContext, workflowContext);
    }

    public static <T> T startWorkflowInstance(long companyId, long groupId, long userId, String className, long classPK, T model, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        if (serviceContext.getWorkflowAction() != 1) {
            return model;
        }
        WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler(className);
        if (workflowHandler == null) {
            if (WorkflowThreadLocal.isEnabled()) {
                throw new WorkflowException("No workflow handler found for " + className);
            }
            return model;
        }
        boolean hasWorkflowInstanceInProgress = WorkflowHandlerRegistryUtil._hasWorkflowInstanceInProgress(companyId, groupId, className, classPK);
        if (hasWorkflowInstanceInProgress) {
            if (_log.isWarnEnabled()) {
                _log.warn(StringBundler.concat((Object[])new Object[]{"Workflow already started for class ", className, " with primary key ", classPK, " in group ", groupId}));
            }
            return model;
        }
        WorkflowDefinitionLink workflowDefinitionLink = null;
        if (WorkflowThreadLocal.isEnabled()) {
            workflowDefinitionLink = workflowHandler.getWorkflowDefinitionLink(companyId, groupId, classPK);
        }
        int status = 1;
        if (workflowDefinitionLink == null) {
            status = 0;
        }
        workflowContext = HashMapBuilder.create(workflowContext).put("companyId", (Serializable)((Object)String.valueOf(companyId))).put("entryClassName", (Serializable)((Object)className)).put("entryClassPK", (Serializable)((Object)String.valueOf(classPK))).put("entryType", (Serializable)((Object)workflowHandler.getType(LocaleUtil.getDefault()))).put("groupId", (Serializable)((Object)String.valueOf(groupId))).put("serviceContext", (Serializable)serviceContext).put("taskComments", (Serializable)((Object)GetterUtil.getString(serviceContext.getAttribute("comments")))).put("userId", (Serializable)((Object)String.valueOf(userId))).build();
        T updatedModel = workflowHandler.updateStatus(model, status, workflowContext);
        if (workflowDefinitionLink != null) {
            Map<String, Serializable> tempWorkflowContext = workflowContext;
            TransactionCommitCallbackUtil.registerCallback(() -> {
                if (!WorkflowHandlerRegistryUtil._hasWorkflowInstanceInProgress(companyId, groupId, className, classPK)) {
                    workflowHandler.startWorkflowInstance(companyId, groupId, userId, classPK, model, tempWorkflowContext);
                }
                return null;
            });
        }
        return updatedModel;
    }

    public static <T> void startWorkflowInstance(long companyId, long userId, String className, long classPK, T model, ServiceContext serviceContext) throws PortalException {
        Map<String, Serializable> workflowContext = (Map<String, Serializable>)((Object)serviceContext.removeAttribute("workflowContext"));
        if (workflowContext == null) {
            workflowContext = Collections.emptyMap();
        }
        WorkflowHandlerRegistryUtil.startWorkflowInstance(companyId, 0L, userId, className, classPK, model, serviceContext, workflowContext);
    }

    public static <T> void startWorkflowInstance(long companyId, long userId, String className, long classPK, T model, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        WorkflowHandlerRegistryUtil.startWorkflowInstance(companyId, 0L, userId, className, classPK, model, serviceContext, workflowContext);
    }

    public static <T> T updateStatus(int status, Map<String, Serializable> workflowContext) throws PortalException {
        String className = (String)((Object)workflowContext.get("entryClassName"));
        WorkflowHandler<T> workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler(className);
        if (workflowHandler != null) {
            return workflowHandler.updateStatus(status, workflowContext);
        }
        return null;
    }

    private static List<WorkflowHandler<?>> _getWorkflowHandlers(ServiceTrackerMap<String, WorkflowHandler<?>> workflowHandlerServiceTrackerMap) {
        ArrayList workflowHandlers = new ArrayList();
        for (String modelClassName : workflowHandlerServiceTrackerMap.keySet()) {
            workflowHandlers.add((WorkflowHandler<?>)workflowHandlerServiceTrackerMap.getService((Object)modelClassName));
        }
        return workflowHandlers;
    }

    private static boolean _hasWorkflowInstanceInProgress(long companyId, long groupId, String className, long classPK) throws PortalException {
        WorkflowInstanceLink workflowInstanceLink = WorkflowInstanceLinkLocalServiceUtil.fetchWorkflowInstanceLink(companyId, groupId, className, classPK);
        if (workflowInstanceLink == null) {
            return false;
        }
        WorkflowInstance workflowInstance = WorkflowInstanceManagerUtil.getWorkflowInstance(companyId, workflowInstanceLink.getWorkflowInstanceId());
        return !workflowInstance.isComplete();
    }

    static {
        _workflowHandlerServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)_bundleContext, WorkflowHandler.class, null, (ServiceReferenceMapper)new WorkflowHandlerServiceReferenceMapper(handler -> true));
        _scopeableWorkflowHandlerServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)_bundleContext, WorkflowHandler.class, null, (ServiceReferenceMapper)new WorkflowHandlerServiceReferenceMapper(handler -> handler.isScopeable()));
    }

    private static class WorkflowHandlerServiceReferenceMapper
    implements ServiceReferenceMapper<String, WorkflowHandler<?>> {
        private final Predicate<WorkflowHandler<?>> _predicate;

        public void map(ServiceReference<WorkflowHandler<?>> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
            WorkflowHandler workflowHandler = (WorkflowHandler)_bundleContext.getService(serviceReference);
            if (this._predicate.test(workflowHandler)) {
                emitter.emit((Object)workflowHandler.getClassName());
            }
        }

        private WorkflowHandlerServiceReferenceMapper(Predicate<WorkflowHandler<?>> predicate) {
            this._predicate = predicate;
        }
    }
}

