/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.social.kernel.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;

public class SocialActivityPermissionUtil {
    public static void check(PermissionChecker permissionChecker, long groupId, String actionId) throws PortalException {
        if (!SocialActivityPermissionUtil.contains(permissionChecker, groupId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, SocialActivityPermissionUtil._getPortletId(), groupId, actionId);
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String actionId) {
        return permissionChecker.isGroupAdmin(groupId) || permissionChecker.isGroupOwner(groupId) || permissionChecker.hasPermission(groupId, SocialActivityPermissionUtil._getPortletId(), SocialActivityPermissionUtil._getPortletId(), actionId);
    }

    private static String _getPortletId() {
        return PortletProviderUtil.getPortletId(SocialActivityPermissionUtil.class.getName(), PortletProvider.Action.EDIT);
    }
}

