/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;

public final class PhasedBackoffWaitStrategy
implements WaitStrategy {
    private static final int SPIN_TRIES = 10000;
    private final long spinTimeoutNanos;
    private final long yieldTimeoutNanos;
    private final BlockingStrategy lockingStrategy;

    public PhasedBackoffWaitStrategy(long spinTimeoutMillis, long yieldTimeoutMillis, TimeUnit units, BlockingStrategy lockingStrategy) {
        this.spinTimeoutNanos = units.toNanos(spinTimeoutMillis);
        this.yieldTimeoutNanos = this.spinTimeoutNanos + units.toNanos(yieldTimeoutMillis);
        this.lockingStrategy = lockingStrategy;
    }

    public static PhasedBackoffWaitStrategy withLock(long spinTimeoutMillis, long yieldTimeoutMillis, TimeUnit units) {
        return new PhasedBackoffWaitStrategy(spinTimeoutMillis, yieldTimeoutMillis, units, new LockBlockingStrategy());
    }

    public static PhasedBackoffWaitStrategy withSleep(long spinTimeoutMillis, long yieldTimeoutMillis, TimeUnit units) {
        return new PhasedBackoffWaitStrategy(spinTimeoutMillis, yieldTimeoutMillis, units, new SleepBlockingStrategy());
    }

    @Override
    public long waitFor(long sequence, Sequence cursor, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException {
        long startTime = 0L;
        int counter = 10000;
        long availableSequence;
        while ((availableSequence = dependentSequence.get()) < sequence) {
            if (0 != --counter) continue;
            if (0L == startTime) {
                startTime = System.nanoTime();
            } else {
                long timeDelta = System.nanoTime() - startTime;
                if (timeDelta > this.yieldTimeoutNanos) {
                    return this.lockingStrategy.waitOnLock(sequence, cursor, dependentSequence, barrier);
                }
                if (timeDelta > this.spinTimeoutNanos) {
                    Thread.yield();
                }
            }
            counter = 10000;
        }
        return availableSequence;
    }

    @Override
    public void signalAllWhenBlocking() {
        this.lockingStrategy.signalAllWhenBlocking();
    }

    private static class SleepBlockingStrategy
    implements BlockingStrategy {
        private SleepBlockingStrategy() {
        }

        @Override
        public long waitOnLock(long sequence, Sequence cursorSequence, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException {
            long availableSequence;
            while ((availableSequence = dependentSequence.get()) < sequence) {
                LockSupport.parkNanos(1L);
            }
            return availableSequence;
        }

        @Override
        public void signalAllWhenBlocking() {
        }
    }

    private static class LockBlockingStrategy
    implements BlockingStrategy {
        private final Lock lock = new ReentrantLock();
        private final Condition processorNotifyCondition = this.lock.newCondition();
        private volatile int numWaiters = 0;

        private LockBlockingStrategy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long waitOnLock(long sequence, Sequence cursorSequence, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException {
            long availableSequence;
            this.lock.lock();
            try {
                ++this.numWaiters;
                while ((availableSequence = cursorSequence.get()) < sequence) {
                    barrier.checkAlert();
                    this.processorNotifyCondition.await(1L, TimeUnit.MILLISECONDS);
                }
            }
            finally {
                --this.numWaiters;
                this.lock.unlock();
            }
            while ((availableSequence = dependentSequence.get()) < sequence) {
                barrier.checkAlert();
            }
            return availableSequence;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void signalAllWhenBlocking() {
            if (0 != this.numWaiters) {
                this.lock.lock();
                try {
                    this.processorNotifyCondition.signalAll();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }

    private static interface BlockingStrategy {
        public long waitOnLock(long var1, Sequence var3, Sequence var4, SequenceBarrier var5) throws AlertException, InterruptedException;

        public void signalAllWhenBlocking();
    }
}

