/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax;

import com.lunatech.doclets.jax.JAXConfiguration;
import com.lunatech.doclets.jax.JAXDoclet;
import com.lunatech.doclets.jax.jaxb.model.JAXBClass;
import com.lunatech.doclets.jax.jaxrs.model.Resource;
import com.lunatech.doclets.jax.jaxrs.model.ResourceMethod;
import com.lunatech.doclets.jax.jpa.model.JPAClass;
import com.lunatech.doclets.jax.writers.DocletWriter;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.taglets.DeprecatedTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.ParamTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.Taglet;
import com.sun.tools.doclets.internal.toolkit.taglets.TagletManager;
import com.sun.tools.doclets.internal.toolkit.taglets.TagletOutput;
import com.sun.tools.doclets.internal.toolkit.taglets.TagletWriter;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static boolean isEmptyOrNull(String str) {
        return str == null || str.length() == 0;
    }

    public static String getParamDoc(MethodDoc declaringMethod, String name) {
        for (ParamTag paramTag : declaringMethod.paramTags()) {
            if (!paramTag.parameterName().equals(name)) continue;
            return paramTag.parameterComment();
        }
        return "";
    }

    public static Object getAnnotationValue(AnnotationDesc annotation) {
        return Utils.getAnnotationValue(annotation, "value");
    }

    public static Object getAnnotationValue(AnnotationDesc annotation, String name) {
        for (AnnotationDesc.ElementValuePair elementValuePair : annotation.elementValues()) {
            if (!elementValuePair.element().name().equals(name)) continue;
            return elementValuePair.value().value();
        }
        return null;
    }

    public static String[] getAnnotationValues(AnnotationDesc annotation) {
        Object value = Utils.getAnnotationValue(annotation);
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        if (value instanceof AnnotationValue[]) {
            AnnotationValue[] values = (AnnotationValue[])value;
            String[] ret = new String[values.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (String)values[i].value();
            }
            return ret;
        }
        throw new IllegalArgumentException("value is not string or string[]: " + value);
    }

    public static boolean hasAnnotation(ProgramElementDoc programElementDoc, Class<?> ... soughtAnnotations) {
        return Utils.findAnnotation(programElementDoc, soughtAnnotations) != null;
    }

    public static MethodDoc findAnnotatedMethod(ClassDoc declaringClass, MethodDoc method, Class<?> ... soughtAnnotations) {
        if (Utils.isExcluded((Doc)method)) {
            return null;
        }
        AnnotationDesc onMethod = Utils.findAnnotation((ProgramElementDoc)method, soughtAnnotations);
        if (onMethod != null) {
            return method;
        }
        for (MethodDoc declaringMethod : declaringClass.methods(false)) {
            if (!Utils.overrides(method, declaringMethod)) continue;
            if (Utils.hasAnnotation((ProgramElementDoc)declaringMethod, soughtAnnotations)) {
                return declaringMethod;
            }
            return null;
        }
        return null;
    }

    private static boolean overrides(MethodDoc overridingMethod, MethodDoc overriddenMethod) {
        return overridingMethod.name().equals(overriddenMethod.name()) && overridingMethod.signature().equals(overriddenMethod.signature());
    }

    public static AnnotationDesc findMethodAnnotation(ClassDoc declaringClass, MethodDoc method, Class<?> ... soughtAnnotations) {
        AnnotationDesc onMethod = Utils.findAnnotation((ProgramElementDoc)method, soughtAnnotations);
        if (onMethod != null) {
            return onMethod;
        }
        for (MethodDoc declaringMethod : declaringClass.methods(false)) {
            if (!Utils.overrides(method, declaringMethod)) continue;
            return Utils.findAnnotation((ProgramElementDoc)declaringMethod, soughtAnnotations);
        }
        return null;
    }

    public static AnnotationDesc findParameterAnnotation(MethodDoc declaringMethod, Parameter parameter, int parameterIndex, Class<?> ... soughtAnnotations) {
        AnnotationDesc onParameter = Utils.findAnnotation(parameter, soughtAnnotations);
        if (onParameter != null) {
            return onParameter;
        }
        Parameter overriddenParameter = declaringMethod.parameters()[parameterIndex];
        return Utils.findAnnotation(overriddenParameter, soughtAnnotations);
    }

    public static List<AnnotationDesc> findAnnotations(ProgramElementDoc programElementDoc, Class<?> ... soughtAnnotations) {
        return Utils.findAnnotations(programElementDoc.annotations(), soughtAnnotations);
    }

    public static AnnotationDesc findAnnotation(ProgramElementDoc programElementDoc, Class<?> ... soughtAnnotations) {
        return Utils.findAnnotation(programElementDoc.annotations(), soughtAnnotations);
    }

    public static AnnotationDesc findAnnotation(Parameter parameter, Class<?> ... soughtAnnotations) {
        return Utils.findAnnotation(parameter.annotations(), soughtAnnotations);
    }

    public static AnnotationDesc findAnnotation(PackageDoc pack, Class<?> ... soughtAnnotations) {
        return Utils.findAnnotation(pack.annotations(), soughtAnnotations);
    }

    public static AnnotationDesc findAnnotation(AnnotationDesc[] annotations, Class<?> ... soughtAnnotations) {
        for (AnnotationDesc annotation : annotations) {
            AnnotationTypeDoc annotationType = annotation.annotationType();
            for (Class<?> soughtAnnotation : soughtAnnotations) {
                if (!annotationType.qualifiedTypeName().equals(soughtAnnotation.getName())) continue;
                return annotation;
            }
        }
        return null;
    }

    public static AnnotationDesc findAnnotation(AnnotationDesc[] annotations, String ... soughtAnnotations) {
        for (AnnotationDesc annotation : annotations) {
            AnnotationTypeDoc annotationType = annotation.annotationType();
            for (String soughtAnnotation : soughtAnnotations) {
                if (!annotationType.qualifiedTypeName().equals(soughtAnnotation)) continue;
                return annotation;
            }
        }
        return null;
    }

    public static List<AnnotationDesc> findAnnotations(AnnotationDesc[] annotations, Class<?> ... soughtAnnotations) {
        LinkedList<AnnotationDesc> ret = new LinkedList<AnnotationDesc>();
        for (AnnotationDesc annotation : annotations) {
            AnnotationTypeDoc annotationType = annotation.annotationType();
            for (Class<?> soughtAnnotation : soughtAnnotations) {
                if (!annotationType.qualifiedTypeName().equals(soughtAnnotation.getName())) continue;
                ret.add(annotation);
            }
        }
        return ret;
    }

    public static ClassDoc findAnnotatedInterface(ClassDoc klass, Class<?> ... soughtAnnotations) {
        Type[] interfaceTypes;
        for (Type interfaceType : interfaceTypes = klass.interfaceTypes()) {
            ClassDoc interfaceClassDoc = interfaceType.asClassDoc();
            if (interfaceClassDoc == null || Utils.isExcluded((Doc)interfaceClassDoc)) continue;
            if (Utils.hasAnnotation((ProgramElementDoc)interfaceClassDoc, soughtAnnotations)) {
                return interfaceClassDoc;
            }
            ClassDoc foundClassDoc = Utils.findAnnotatedInterface(interfaceClassDoc, soughtAnnotations);
            if (foundClassDoc == null) continue;
            return foundClassDoc;
        }
        return null;
    }

    public static ClassDoc findAnnotatedClass(ClassDoc klass, Class<?> ... soughtAnnotations) {
        if (!klass.isClass() || Utils.isExcluded((Doc)klass)) {
            return null;
        }
        if (Utils.hasAnnotation((ProgramElementDoc)klass, soughtAnnotations)) {
            return klass;
        }
        ClassDoc foundClassDoc = Utils.findAnnotatedInterface(klass, soughtAnnotations);
        if (foundClassDoc != null) {
            return foundClassDoc;
        }
        Type superclass = klass.superclassType();
        if (superclass != null && superclass.asClassDoc() != null) {
            return Utils.findAnnotatedClass(superclass.asClassDoc(), soughtAnnotations);
        }
        return null;
    }

    public static Type findSuperType(Type type, String typeName) {
        ClassDoc doc = type.asClassDoc();
        if (doc == null) {
            return null;
        }
        if (doc.qualifiedTypeName().equals(typeName)) {
            return type;
        }
        if (doc.isInterface()) {
            return Utils.findSuperTypeFromInterface(doc, typeName);
        }
        if (doc.isClass() && !doc.isEnum() && !doc.isError() && !doc.isException()) {
            return Utils.findSuperTypeFromClass(doc, typeName);
        }
        return null;
    }

    public static Type findSuperTypeFromInterface(ClassDoc klass, String typeName) {
        Type[] interfaceTypes;
        for (Type interfaceType : interfaceTypes = klass.interfaceTypes()) {
            ClassDoc interfaceClassDoc = interfaceType.asClassDoc();
            if (interfaceClassDoc == null) continue;
            if (interfaceClassDoc.qualifiedTypeName().equals(typeName)) {
                return interfaceClassDoc;
            }
            Type foundType = Utils.findSuperTypeFromInterface(interfaceClassDoc, typeName);
            if (foundType == null) continue;
            return foundType;
        }
        return null;
    }

    public static Type findSuperTypeFromClass(ClassDoc klass, String typeName) {
        if (klass.qualifiedTypeName().equals(typeName)) {
            return klass;
        }
        Type foundType = Utils.findSuperTypeFromInterface(klass, typeName);
        if (foundType != null) {
            return foundType;
        }
        Type superclass = klass.superclassType();
        if (superclass != null && superclass.asClassDoc() != null) {
            return Utils.findSuperTypeFromClass(superclass.asClassDoc(), typeName);
        }
        return null;
    }

    public static String appendURLFragments(String ... fragments) {
        StringBuilder strbuf = new StringBuilder();
        for (String fragment : fragments) {
            if (fragment == null || fragment.length() == 0) continue;
            if (!strbuf.toString().endsWith("/") && !fragment.startsWith("/")) {
                strbuf.append("/");
            }
            if (strbuf.toString().endsWith("/") && fragment.startsWith("/")) {
                fragment = fragment.substring(1);
            }
            strbuf.append(fragment);
        }
        return strbuf.toString();
    }

    public static String getFirstURLFragment(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.length() == 0) {
            return null;
        }
        String[] fragments = path.split("/+");
        if (fragments.length == 0) {
            return null;
        }
        return fragments[0];
    }

    public static String slashify(String url) {
        if (url == null) {
            return "";
        }
        if (!url.endsWith("/")) {
            return url + "/";
        }
        return url;
    }

    public static String unEndSlashify(String url) {
        if (url == null) {
            return "";
        }
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String unStartSlashify(String url) {
        if (url == null) {
            return "";
        }
        if (!url.startsWith("/")) {
            return url;
        }
        if (url.length() == 1) {
            return "";
        }
        return url.substring(1);
    }

    public static String classToPath(JAXBClass jaxbClass) {
        return DirectoryManager.getPath((String)jaxbClass.getPackageName());
    }

    public static String classToPath(JPAClass jpaClass) {
        return DirectoryManager.getPath((String)jpaClass.getPackageName());
    }

    public static String classToPath(ClassDoc cDoc) {
        return DirectoryManager.getPath((String)cDoc.containingPackage().name());
    }

    public static String urlToPath(Resource resource) {
        String name = resource.getAbsolutePath();
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name;
    }

    public static String urlToSystemPath(Resource resource) {
        String name = resource.getAbsolutePath();
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name.replace('/', File.separatorChar);
    }

    public static String urlToClass(ClassDoc from, ClassDoc to) {
        return Utils.classToRoot(from) + Utils.classToPath(to) + "/" + to.name() + ".html";
    }

    public static String urlToClass(JAXBClass from, JAXBClass to) {
        return Utils.classToRoot(from) + Utils.classToPath(to) + "/" + to.getShortClassName() + ".html";
    }

    public static String urlToClass(JPAClass from, JPAClass to) {
        return Utils.classToRoot(from) + Utils.classToPath(to) + "/" + to.getShortClassName() + ".html";
    }

    public static String urlToType(ClassDoc klass) {
        return DirectoryManager.getPathToClass((ClassDoc)klass);
    }

    public static String classToRoot(JAXBClass klass) {
        return DirectoryManager.getRelativePath((String)klass.getPackageName());
    }

    public static String classToRoot(ClassDoc cDoc) {
        return DirectoryManager.getRelativePath((PackageDoc)cDoc.containingPackage());
    }

    public static String classToRoot(JPAClass klass) {
        return DirectoryManager.getRelativePath((String)klass.getPackageName());
    }

    public static String urlToRoot(Resource resource) {
        String from = resource.getAbsolutePath();
        if (from.startsWith("/")) {
            from = from.substring(1);
        }
        return Utils.urlToRoot(from);
    }

    public static String urlToRoot(String from) {
        if (from == null || from.length() == 0) {
            return "";
        }
        StringBuilder pathstr = new StringBuilder();
        for (int i = 0; i < from.length(); ++i) {
            char ch = from.charAt(i);
            if (ch != '/') continue;
            pathstr.append("../");
        }
        pathstr.append("../");
        return pathstr.toString();
    }

    public static void createDirectory(String path) {
        if (path == null || path.length() == 0) {
            return;
        }
        File dir = new File(path);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Could not create path: " + path);
        }
    }

    public static void genTagOuput(TagletManager tagletManager, Doc doc, Taglet[] taglets, TagletWriter writer, TagletOutput output, Set<String> tagletsToPrint) {
        tagletManager.checkTags(doc, doc.tags(), false);
        tagletManager.checkTags(doc, doc.inlineTags(), true);
        TagletOutput currentOutput = null;
        for (int i = 0; i < taglets.length; ++i) {
            block3: {
                if (!tagletsToPrint.contains(taglets[i].getName()) || doc instanceof ClassDoc && taglets[i] instanceof ParamTaglet || taglets[i] instanceof DeprecatedTaglet) continue;
                try {
                    currentOutput = taglets[i].getTagletOutput(doc, writer);
                }
                catch (IllegalArgumentException e) {
                    Tag[] tags = doc.tags(taglets[i].getName());
                    if (tags.length <= 0) break block3;
                    currentOutput = taglets[i].getTagletOutput(tags[0], writer);
                }
            }
            if (currentOutput == null) continue;
            tagletManager.seenCustomTag(taglets[i].getName());
            output.appendOutput(currentOutput);
        }
    }

    public static void copyResources(JAXConfiguration configuration) {
        InputStream defaultCSS = Utils.class.getResourceAsStream("/doclet.css");
        if (defaultCSS == null) {
            throw new RuntimeException("Failed to find doclet CSS (incorrect jax-doclets packaging?)");
        }
        if (!Utils.isEmptyOrNull(configuration.parentConfiguration.stylesheetfile)) {
            try {
                FileInputStream stream = new FileInputStream(configuration.parentConfiguration.stylesheetfile);
                Utils.copyResource(stream, new File(configuration.parentConfiguration.destDirName, "doclet.css"));
                Utils.copyResource(defaultCSS, new File(configuration.parentConfiguration.destDirName, "default-doclet.css"));
            }
            catch (Exception x) {
                throw new RuntimeException("Failed to read user stylesheet " + configuration.parentConfiguration.stylesheetfile, x);
            }
        } else {
            Utils.copyResource(defaultCSS, new File(configuration.parentConfiguration.destDirName, "doclet.css"));
        }
    }

    public static void copyJPAResources(JAXConfiguration configuration) {
        Utils.copyResource(configuration, "graph.js");
        Utils.copyResource(configuration, "jit.js");
    }

    private static void copyResource(JAXConfiguration configuration, String name) {
        InputStream graphHTML = Utils.class.getResourceAsStream("/" + name);
        if (graphHTML == null) {
            throw new RuntimeException("Failed to find " + name + " (incorrect jax-doclets packaging?)");
        }
        Utils.copyResource(graphHTML, new File(configuration.parentConfiguration.destDirName, name));
    }

    private static void copyResource(InputStream stream, File output) {
        try {
            int read;
            FileOutputStream os = new FileOutputStream(output);
            byte[] buffer = new byte[1024];
            while ((read = stream.read(buffer)) >= 0) {
                ((OutputStream)os).write(buffer, 0, read);
            }
            os.flush();
            ((OutputStream)os).close();
            stream.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String readResource(File input) {
        try {
            int read;
            FileReader stream = new FileReader(input);
            StringBuilder output = new StringBuilder();
            char[] buffer = new char[1024];
            while ((read = stream.read(buffer)) >= 0) {
                output.append(buffer, 0, read);
            }
            ((Reader)stream).close();
            return output.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> getProducesClass() {
        try {
            return Class.forName("javax.ws.rs.Produces");
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName("javax.ws.rs.ProduceMime");
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    public static Class<?> getConsumesClass() {
        try {
            return Class.forName("javax.ws.rs.Consumes");
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName("javax.ws.rs.ConsumeMime");
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    public static String getExternalLink(Configuration configuration, Type type, HtmlDocletWriter writer) {
        return Utils.getExternalLink(configuration, type.asClassDoc().containingPackage().name(), type.typeName(), writer);
    }

    public static String getExternalLink(Configuration configuration, String className, HtmlDocletWriter writer) {
        int lastSep = className.lastIndexOf(46);
        if (lastSep == -1) {
            return Utils.getExternalLink(configuration, "", className, writer);
        }
        do {
            String link;
            if ((link = Utils.getExternalLink(configuration, className.substring(0, lastSep), className.substring(lastSep + 1), writer)) == null) continue;
            return link;
        } while ((lastSep = className.lastIndexOf(46, lastSep - 1)) > -1);
        return null;
    }

    private static String getExternalLink(Configuration configuration, String packageName, String className, HtmlDocletWriter writer) {
        return configuration.extern.getExternalLink(packageName, writer.relativePath, className + ".html");
    }

    public static String getLinkTypeName(String url) {
        int lastSep = url.lastIndexOf(47);
        if (lastSep != -1 && url.endsWith(".html")) {
            return url.substring(lastSep + 1, url.length() - 5);
        }
        throw new IllegalArgumentException("Invalid type link: " + url);
    }

    public static Tag getTag(Doc doc, String tagName) {
        Tag[] tags = doc.tags("@" + tagName);
        if (tags != null && tags.length > 0) {
            return tags[0];
        }
        return null;
    }

    public static Tag[] getTags(Doc doc, String tagName) {
        Tag[] tags = doc.tags("@" + tagName);
        if (tags != null && tags.length > 0) {
            return tags;
        }
        return null;
    }

    public static String getOption(String[][] options, String optionName) {
        for (String[] option : options) {
            String name = option[0];
            if (!optionName.equals(name)) continue;
            String value = option.length > 1 ? option[1] : null;
            return value;
        }
        return null;
    }

    public static List<String> getOptions(String[][] options, String optionName) {
        ArrayList<String> result = new ArrayList<String>();
        for (String[] option : options) {
            String name = option[0];
            if (!optionName.equals(name)) continue;
            String value = option.length > 1 ? option[1] : null;
            result.add(value);
        }
        return result;
    }

    public static boolean hasOption(String[][] options, String optionName) {
        for (String[] option : options) {
            String name = option[0];
            if (!optionName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCollection(Type type) {
        Type collectionType = Utils.findSuperType(type, "java.util.Collection");
        return collectionType != null;
    }

    public static boolean isArray(Type type) {
        String dimension = type.dimension();
        return dimension != null && dimension.length() > 0;
    }

    public static Type getCollectionType(Type type, JAXDoclet<?> doclet) {
        Type collectionType = Utils.findSuperType(type, "java.util.Collection");
        if (collectionType != null) {
            Type[] types;
            ParameterizedType parameterizedType = type.asParameterizedType();
            Type[] typeArray = types = parameterizedType == null ? null : parameterizedType.typeArguments();
            if (types != null && types.length == 1) {
                return types[0];
            }
            return doclet.forName("java.lang.Object");
        }
        return type;
    }

    public static Type resolveType(String typeName, ClassDoc klass, JAXDoclet<?> doclet) {
        ClassDoc type;
        Utils.log("resolving " + typeName + " in " + klass.qualifiedTypeName());
        for (ClassDoc classDoc : klass.innerClasses(false)) {
            if (!classDoc.simpleTypeName().equals(typeName)) continue;
            return classDoc;
        }
        if (klass.typeName().equals(typeName)) {
            return klass;
        }
        try {
            for (ClassDoc classDoc : klass.importedClasses()) {
                if (!classDoc.typeName().equals(typeName)) continue;
                return classDoc;
            }
            for (ClassDoc classDoc : klass.importedPackages()) {
                for (ClassDoc importedClass : classDoc.allClasses(false)) {
                    if (!importedClass.typeName().equals(typeName)) continue;
                    return importedClass;
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if ((type = doclet.forName(typeName)) != null) {
            return type;
        }
        Utils.log("resolving failed for " + typeName + " in " + klass.qualifiedTypeName());
        return null;
    }

    public static JaxType parseType(String typeName, ClassDoc containingClass, JAXDoclet<?> doclet) throws InvalidJaxTypeException {
        typeName = typeName.trim();
        char[] chars = typeName.toCharArray();
        Stack<JaxType> types = new Stack<JaxType>();
        JaxType currentType = new JaxType();
        types.push(currentType);
        StringBuffer currentTypeName = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            JaxType parameterType;
            char c = chars[i];
            Utils.log("Looking at char " + c);
            if (c == '<') {
                Utils.log("Start params for " + currentTypeName);
                Utils.setupType(currentType, currentTypeName, containingClass, doclet);
                parameterType = new JaxType();
                currentType.parameters.add(parameterType);
                currentType = parameterType;
                types.push(currentType);
                continue;
            }
            if (c == '>') {
                if (currentTypeName.length() > 0) {
                    Utils.setupType(currentType, currentTypeName, containingClass, doclet);
                }
                types.pop();
                currentType = (JaxType)types.peek();
                Utils.log("End params for " + currentType.typeName);
                if (types.size() >= 1) continue;
                throw new InvalidJaxTypeException();
            }
            if (c == ',') {
                if (currentTypeName.length() > 0) {
                    Utils.setupType(currentType, currentTypeName, containingClass, doclet);
                    types.pop();
                    currentType = (JaxType)types.peek();
                }
                Utils.log("Next params for " + currentType.typeName);
                if (types.size() < 1) {
                    throw new InvalidJaxTypeException();
                }
                parameterType = new JaxType();
                currentType.parameters.add(parameterType);
                currentType = parameterType;
                types.push(currentType);
                continue;
            }
            if (c == '[' || c == ']') {
                Utils.log("Dimension for " + currentType.typeName);
                if (currentTypeName.length() > 0) {
                    Utils.setupType(currentType, currentTypeName, containingClass, doclet);
                }
                currentType.dimension = currentType.dimension + c;
                continue;
            }
            Utils.log("Name char: " + currentTypeName);
            if (currentType.typeName != null) {
                throw new InvalidJaxTypeException();
            }
            currentTypeName.append(c);
        }
        if (currentTypeName.length() > 0) {
            Utils.log("End of type without param or dimension for " + currentTypeName);
            Utils.setupType(currentType, currentTypeName, containingClass, doclet);
        }
        if (types.size() != 1) {
            throw new InvalidJaxTypeException();
        }
        return currentType;
    }

    public static String removeFragmentRegexes(String fragment, Map<String, String> regexFragments) {
        Pattern regexPattern = Pattern.compile("\\{(\\w[\\w\\.-]*)\\s*:");
        Matcher regexMatcher = regexPattern.matcher(fragment);
        int start = 0;
        char[] fragmentArray = fragment.toCharArray();
        StringBuffer strbuf = new StringBuffer();
        while (regexMatcher.find(start)) {
            strbuf.append(fragment.substring(start, regexMatcher.start()));
            String name = regexMatcher.group(1);
            strbuf.append("{").append(name);
            int openBraces = 1;
            start = regexMatcher.end();
            while (start < fragmentArray.length) {
                char c;
                if ((c = fragmentArray[start++]) == '{') {
                    ++openBraces;
                    continue;
                }
                if (c != '}' || --openBraces != 0) continue;
                break;
            }
            if (openBraces > 0) {
                throw new RuntimeException("Invalid Path fragment: " + fragment);
            }
            String regex = fragment.substring(regexMatcher.end(), start - 1);
            if (regexFragments != null) {
                regexFragments.put(name, regex);
            }
            strbuf.append("}");
        }
        strbuf.append(fragment.substring(start, fragmentArray.length));
        return strbuf.toString();
    }

    private static void setupType(JaxType currentType, StringBuffer currentTypeName, ClassDoc containingClass, JAXDoclet<?> doclet) throws InvalidJaxTypeException {
        if (currentTypeName.length() == 0) {
            throw new InvalidJaxTypeException();
        }
        currentType.typeName = currentTypeName.toString();
        currentType.type = Utils.resolveType(currentType.typeName, containingClass, doclet);
        currentTypeName.setLength(0);
    }

    private static String addContextPath(JAXConfiguration config, String resource) {
        String jaxrscontext = Utils.getOption(config.parentConfiguration.root.options(), "-jaxrscontext");
        if (jaxrscontext == null) {
            return Utils.appendURLFragments("/", resource);
        }
        return Utils.appendURLFragments(jaxrscontext, resource);
    }

    public static String getDisplayURL(DocletWriter writer, Resource resource, ResourceMethod method) {
        return Utils.addContextPath(writer.getConfiguration(), method.getURL(resource));
    }

    public static String getAbsolutePath(DocletWriter writer, Resource resource) {
        return Utils.addContextPath(writer.getConfiguration(), resource.getAbsolutePath());
    }

    public static String getAbsolutePath(JAXConfiguration config, Resource resource) {
        return Utils.addContextPath(config, resource.getAbsolutePath());
    }

    public static void log(String mesg) {
    }

    private static boolean isExcluded(Doc doc) {
        return doc.tags("exclude").length != 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JaxType {
        String typeName;
        Type type;
        List<JaxType> parameters = new LinkedList<JaxType>();
        String dimension = "";

        public String getDimension() {
            return this.dimension;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Type getType() {
            return this.type;
        }

        public List<JaxType> getParameters() {
            return this.parameters;
        }

        public boolean hasParameters() {
            return !this.parameters.isEmpty();
        }
    }

    public static class InvalidJaxTypeException
    extends Exception {
    }
}

