/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.apt;

import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import javax.ws.rs.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"javax.ws.rs.Path"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class PathProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        Messager messager = this.processingEnv.getMessager();
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(Path.class);
        for (Element element : elements) {
            Path annotation = element.getAnnotation(Path.class);
            if (annotation == null || element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE) continue;
            messager.printMessage(Diagnostic.Kind.NOTE, "Generating documentation class for : " + element);
            Name name = element.getSimpleName();
            PackageElement elementPackage = elementUtils.getPackageOf(element);
            String doc = elementUtils.getDocComment(element);
            String className = elementPackage.getQualifiedName() + "." + name + "_Doc";
            messager.printMessage(Diagnostic.Kind.NOTE, "Class: " + className);
            try {
                JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(className, element);
                Writer writer = sourceFile.openWriter();
                writer.append("package " + elementPackage.getQualifiedName() + ";\n\n");
                writer.append("import javax.annotation.Generated;\n\n");
                writer.append("@Generated(\"" + this.getClass().getCanonicalName() + "\")\n");
                writer.append("public class " + name + "_Doc {\n");
                writer.append(" public String getDoc(){\n");
                writer.append("return \"" + doc.replaceAll("\n", "\\\\n") + "\";\n");
                writer.append("}\n}\n");
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

