/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxb.model;

import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxb.model.JAXBClass;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Type;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlSchemaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBMember
implements Comparable<JAXBMember> {
    protected AnnotationDesc xmlAnnotation;
    protected ProgramElementDoc property;
    protected String name;
    protected String namespace;
    protected JAXBClass klass;
    private boolean isIDREF;
    private boolean isID;
    private static HashMap<String, Object> hmKnownUnknownXSDTypes = new HashMap();

    public JAXBMember(JAXBClass klass, ProgramElementDoc property, String name, AnnotationDesc xmlAnnotation) {
        this.xmlAnnotation = xmlAnnotation;
        this.property = property;
        this.name = name;
        if (xmlAnnotation != null) {
            this.namespace = (String)Utils.getAnnotationValue(xmlAnnotation, "namespace");
        }
        this.klass = klass;
        this.isIDREF = Utils.findAnnotation(property, XmlIDREF.class) != null;
        this.isID = Utils.findAnnotation(property, XmlID.class) != null;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Doc getJavaDoc() {
        return this.property;
    }

    private Type getType() {
        if (this.property.isMethod()) {
            return ((MethodDoc)this.property).returnType();
        }
        return ((FieldDoc)this.property).type();
    }

    public boolean isCollectionOrArray() {
        return Utils.isCollection(this.getType()) || this.isArray();
    }

    public boolean isCollection() {
        if (Utils.isCollection(this.getType())) {
            return !this.isXmlList();
        }
        if (this.isArray()) {
            if (this.isByteType()) {
                return false;
            }
            return !this.isXmlList();
        }
        return false;
    }

    private boolean isXmlList() {
        AnnotationDesc xmlListAnnot = Utils.findAnnotation(this.property, XmlList.class);
        return xmlListAnnot != null;
    }

    public boolean isArray() {
        return Utils.isArray(this.getType());
    }

    public boolean isByteType() {
        String typeName = this.getJavaTypeName();
        return typeName.equals("java.lang.Byte") || typeName.equals("byte");
    }

    public Type getJavaType() {
        return Utils.getCollectionType(this.getType(), this.klass.getDoclet());
    }

    public String getJavaTypeName() {
        return this.getJavaType().qualifiedTypeName();
    }

    public boolean isJAXBType() {
        Type type = this.getJavaType();
        return !type.isPrimitive() && this.klass.getRegistry().isJAXBClass(type.qualifiedTypeName());
    }

    public String getXSDType() {
        String name;
        AnnotationDesc xmlSchemaTypeAnnot = Utils.findAnnotation(this.property, XmlSchemaType.class);
        if (xmlSchemaTypeAnnot != null && (name = (String)Utils.getAnnotationValue(xmlSchemaTypeAnnot, "name")) != null) {
            return "xsd:" + name;
        }
        if (this.isXmlList()) {
            return "xsd:list[" + this.getXSDTypeFromJavaType() + "]";
        }
        return this.getXSDTypeFromJavaType();
    }

    public String getXSDTypeFromJavaType() {
        String typeName = this.getJavaTypeName();
        if (typeName.equals("java.lang.String")) {
            return "xsd:string";
        }
        if (typeName.equals("java.lang.Character") || typeName.equals("char")) {
            return "xsd:string";
        }
        if (typeName.equals("java.util.Date")) {
            return "xsd:datetime";
        }
        if (typeName.equals("java.lang.Integer") || typeName.equals("int")) {
            return "xsd:int";
        }
        if (typeName.equals("java.lang.Long") || typeName.equals("long")) {
            return "xsd:long";
        }
        if (typeName.equals("java.lang.Short") || typeName.equals("short")) {
            return "xsd:short";
        }
        if (typeName.equals("java.lang.Byte") || typeName.equals("byte")) {
            if (this.isArray()) {
                return "xsd:base64Binary";
            }
            return "xsd:byte";
        }
        if (typeName.equals("java.lang.Float") || typeName.equals("float")) {
            return "xsd:float";
        }
        if (typeName.equals("java.lang.Double") || typeName.equals("double")) {
            return "xsd:double";
        }
        if (typeName.equals("java.lang.Boolean") || typeName.equals("boolean")) {
            return "xsd:boolean";
        }
        if (typeName.equals("java.lang.Object")) {
            return "xsd:any";
        }
        ClassDoc type = this.getJavaType().asClassDoc();
        if (type.isEnum()) {
            FieldDoc[] constants = type.enumConstants();
            StringBuffer ret = new StringBuffer();
            boolean first = true;
            for (FieldDoc constant : constants) {
                if (!first) {
                    ret.append(" | ");
                } else {
                    first = false;
                }
                ret.append(constant.name());
            }
            return ret.toString();
        }
        if (null == hmKnownUnknownXSDTypes.get(typeName)) {
            System.err.println("WARNING: unknown XSD type " + typeName);
            hmKnownUnknownXSDTypes.put(typeName, Boolean.TRUE);
        }
        return typeName;
    }

    public boolean isIDREF() {
        return this.isIDREF;
    }

    public boolean isID() {
        return this.isID;
    }

    @Override
    public int compareTo(JAXBMember other) {
        return this.name.compareToIgnoreCase(other.name);
    }

    public String getJSONType() {
        String typeName = this.getJavaTypeName();
        if (typeName.equals("java.lang.String")) {
            return "String";
        }
        if (typeName.equals("java.lang.Character") || typeName.equals("char")) {
            return "String";
        }
        if (typeName.equals("java.util.Date")) {
            return "Date";
        }
        if (typeName.equals("java.lang.Integer") || typeName.equals("int")) {
            return "Number";
        }
        if (typeName.equals("java.lang.Long") || typeName.equals("long")) {
            return "Number";
        }
        if (typeName.equals("java.lang.Short") || typeName.equals("short")) {
            return "Number";
        }
        if (typeName.equals("java.lang.Byte") || typeName.equals("byte")) {
            return "Number";
        }
        if (typeName.equals("java.lang.Float") || typeName.equals("float")) {
            return "Number";
        }
        if (typeName.equals("java.lang.Double") || typeName.equals("double")) {
            return "Number";
        }
        if (typeName.equals("java.lang.Boolean") || typeName.equals("boolean")) {
            return "Boolean";
        }
        if (typeName.equals("java.lang.Object")) {
            return "Object";
        }
        ClassDoc type = this.getJavaType().asClassDoc();
        if (type.isEnum()) {
            FieldDoc[] constants = type.enumConstants();
            StringBuffer ret = new StringBuffer();
            boolean first = true;
            for (FieldDoc constant : constants) {
                if (!first) {
                    ret.append(" | ");
                } else {
                    first = false;
                }
                ret.append("'").append(constant.name()).append("'");
            }
            return ret.toString();
        }
        if (null == hmKnownUnknownXSDTypes.get(typeName)) {
            System.err.println("WARNING: unknown XSD type " + typeName);
            hmKnownUnknownXSDTypes.put(typeName, Boolean.TRUE);
        }
        return typeName;
    }
}

