/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxrs.model;

import com.lunatech.doclets.jax.jaxrs.JAXRSConfiguration;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoTypes {
    public static Comparator<Type> TYPE_COMPARATOR = new Comparator<Type>(){

        @Override
        public int compare(Type t0, Type t1) {
            String qt1;
            if (t0 == t1) {
                return 0;
            }
            if (t0 == null) {
                return -1;
            }
            if (t1 == null) {
                return 1;
            }
            String qt0 = t0.qualifiedTypeName();
            if (qt0 == (qt1 = t1.qualifiedTypeName())) {
                return 0;
            }
            if (qt0 == null) {
                return -1;
            }
            if (qt1 == null) {
                return 1;
            }
            return qt0.compareTo(qt1);
        }
    };
    private final JAXRSConfiguration config;
    private final Set<ClassDoc> resolvedTypes = new TreeSet<Type>(TYPE_COMPARATOR);
    private final Set<Type> unresolvedTypes = new TreeSet<Type>(TYPE_COMPARATOR);

    public PojoTypes(JAXRSConfiguration config) {
        this.config = config;
    }

    public Set<ClassDoc> getResolvedTypes() {
        return Collections.unmodifiableSet(this.resolvedTypes);
    }

    public Set<Type> getUnresolvedTypes() {
        return Collections.unmodifiableSet(this.unresolvedTypes);
    }

    public boolean resolveUsedType(Type type) {
        ClassDoc cDoc = type.asClassDoc();
        if (type.asParameterizedType() != null) {
            for (Type param : type.asParameterizedType().typeArguments()) {
                this.resolveUsedType(param);
            }
        }
        if (this.isPojoToDocument(type)) {
            if (!this.resolvedTypes.contains(cDoc)) {
                this.resolvedTypes.add(cDoc);
                this.resolveFieldDtos(cDoc);
            }
            return true;
        }
        if (cDoc != null) {
            this.unresolvedTypes.add((Type)cDoc);
            return false;
        }
        return false;
    }

    private void resolveFieldDtos(ClassDoc cDoc) {
        for (FieldDoc fDoc : cDoc.fields(false)) {
            this.resolveUsedType(fDoc.type());
        }
    }

    public void resolveSubclassDtos() {
        int resolved = this.resolvedTypes.size();
        while (true) {
            for (ClassDoc klass : this.config.parentConfiguration.root.classes()) {
                this.resolveSubclassDtos(klass);
            }
            if (this.resolvedTypes.size() == resolved) break;
            resolved = this.resolvedTypes.size();
        }
    }

    private void resolveSubclassDtos(ClassDoc potentialSubclass) {
        ClassDoc superClass = potentialSubclass.superclass();
        if (superClass != null) {
            if (this.resolvedTypes.contains(superClass)) {
                this.resolveUsedType((Type)potentialSubclass);
            } else {
                this.resolveSubclassDtos(superClass);
            }
        }
    }

    public boolean isPojoToDocument(Type type) {
        if (type.isPrimitive()) {
            return false;
        }
        if (type.asClassDoc() == null) {
            return false;
        }
        if (this.config.onlyOutputPojosMatching != null) {
            Matcher m = this.config.onlyOutputPojosMatching.matcher(type.qualifiedTypeName());
            return m.matches();
        }
        return true;
    }

    public List<ClassDoc> getSubclasses(ClassDoc cDoc) {
        ArrayList<ClassDoc> subClasses = new ArrayList<ClassDoc>();
        for (ClassDoc potentialSubclass : this.resolvedTypes) {
            if (!this.isSubclass(cDoc, potentialSubclass)) continue;
            subClasses.add(potentialSubclass);
        }
        return subClasses;
    }

    private boolean isSubclass(ClassDoc cDoc, ClassDoc potentialSubclass) {
        ClassDoc superClass = potentialSubclass.superclass();
        return superClass != null && (superClass.qualifiedTypeName().equals(cDoc.qualifiedTypeName()) || this.isSubclass(cDoc, superClass));
    }
}

