/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxrs.writers;

import com.lunatech.doclets.jax.JAXConfiguration;
import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxrs.JAXRSDoclet;
import com.lunatech.doclets.jax.jaxrs.model.JAXRSApplication;
import com.lunatech.doclets.jax.jaxrs.model.Resource;
import com.lunatech.doclets.jax.jaxrs.model.ResourceMethod;
import com.lunatech.doclets.jax.jaxrs.writers.DocletWriter;
import com.lunatech.doclets.jax.jaxrs.writers.JAXRSHtmlDocletWriter;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import java.io.IOException;

public class IndexWriter
extends DocletWriter {
    public IndexWriter(JAXConfiguration configuration, JAXRSApplication application, JAXRSDoclet doclet) {
        super(configuration, IndexWriter.getWriter(configuration, application), application, application.getRootResource(), doclet);
    }

    private static HtmlDocletWriter getWriter(JAXConfiguration configuration, JAXRSApplication application) {
        try {
            return new JAXRSHtmlDocletWriter(application, configuration, "", "overview-index.html", "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write() {
        this.printPrelude("Resource index", "Index");
        this.printResources();
        this.tag("hr");
        this.printPostlude("Index");
        this.writer.flush();
        this.writer.close();
    }

    private void printResources() {
        this.tag("hr");
        this.open("table class='info'");
        this.around("caption class='TableCaption'", "Resources");
        this.open("tbody");
        this.open("tr");
        this.around("th class='TableHeader'", "Method");
        this.around("th class='TableHeader'", "URL");
        this.around("th class='TableHeader'", "Description");
        this.close("tr");
        this.printResource(this.resource);
        this.close("tbody");
        this.close("table");
    }

    private void printResource(Resource resource) {
        for (ResourceMethod method : resource.getMethods()) {
            if (method.isResourceLocator()) continue;
            for (String httpMethod : method.getMethods()) {
                this.printMethod(resource, method, httpMethod);
            }
        }
        for (String name : resource.getResources().keySet()) {
            Resource subResource = resource.getResources().get(name);
            this.printResource(subResource);
        }
    }

    private void printMethod(Resource resource, ResourceMethod method, String httpMethod) {
        String path = Utils.urlToPath(resource);
        if (path.length() == 0) {
            path = ".";
        }
        this.open("tr");
        this.open("td");
        this.open("a href='" + path + "/index.html#" + httpMethod + "'");
        this.around("tt", httpMethod);
        this.close("a");
        this.close("td");
        this.open("td");
        this.open("a href='" + path + "/index.html'");
        this.around("tt", Utils.getDisplayURL(this, resource, method));
        this.close("a");
        this.close("td");
        this.open("td");
        MethodDoc javaDoc = method.getJavaDoc();
        if (javaDoc != null && javaDoc.firstSentenceTags() != null) {
            this.writer.printSummaryComment((Doc)javaDoc);
        }
        this.close("td");
        this.close("tr");
    }

    protected void printHeader() {
        this.printHeader("Resource index");
    }
}

