/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxrs.writers;

import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxrs.JAXRSDoclet;
import com.lunatech.doclets.jax.jaxrs.model.JAXRSApplication;
import com.lunatech.doclets.jax.jaxrs.model.MethodOutput;
import com.lunatech.doclets.jax.jaxrs.model.MethodParameter;
import com.lunatech.doclets.jax.jaxrs.model.PojoTypes;
import com.lunatech.doclets.jax.jaxrs.model.ResourceMethod;
import com.lunatech.doclets.jax.jaxrs.writers.DataObjectIndexWriter;
import com.lunatech.doclets.jax.jaxrs.writers.DocletWriter;
import com.lunatech.doclets.jax.jaxrs.writers.ResourceWriter;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.formats.html.TagletOutputImpl;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.taglets.TagletOutput;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodWriter
extends DocletWriter {
    private ResourceMethod method;

    public MethodWriter(ResourceMethod method, ResourceWriter resourceWriter, JAXRSDoclet doclet, JAXRSApplication application) {
        super(resourceWriter.getConfiguration(), resourceWriter.getWriter(), application, resourceWriter.getResource(), doclet);
        this.method = method;
    }

    public void print(PojoTypes types) {
        for (String httpMethod : this.method.getMethods()) {
            this.printMethod(httpMethod, types);
        }
    }

    private void printMethod(String httpMethod, PojoTypes types) {
        boolean doubleExample;
        this.around("a name='" + httpMethod + "'", "");
        this.around("h3", httpMethod + " " + Utils.getAbsolutePath(this, this.resource));
        if (!Utils.isEmptyOrNull(this.method.getDoc())) {
            this.open("p");
            this.writer.printInlineComment((Doc)this.method.getJavaDoc());
            this.close("p");
        }
        this.printIncludes();
        this.open("dl");
        boolean bl = doubleExample = this.getJAXRSConfiguration().enableHTTPExample && this.getJAXRSConfiguration().enableJavaScriptExample;
        if (doubleExample) {
            this.open("table class='examples'", "tr");
            this.open("td");
        }
        if (this.getJAXRSConfiguration().enableHTTPExample) {
            this.printHTTPExample(httpMethod);
        }
        if (doubleExample) {
            this.close("td");
            this.open("td");
        }
        if (this.getJAXRSConfiguration().enableJavaScriptExample) {
            this.printAPIExample();
        }
        if (doubleExample) {
            this.close("td");
            this.close("tr", "table");
        }
        this.printInput(types);
        this.printOutput(types);
        this.printParameters(this.method.getQueryParameters(), "Query");
        this.printParameters(this.method.getMatrixParameters(), "Matrix");
        this.printParameters(this.method.getFormParameters(), "Form");
        this.printParameters(this.method.getCookieParameters(), "Cookie");
        this.printParameters(this.method.getHeaderParameters(), "Header");
        this.printMIMEs(this.method.getProduces(), "Produces");
        this.printMIMEs(this.method.getConsumes(), "Consumes");
        this.printHTTPCodes();
        this.printHTTPRequestHeaders();
        this.printHTTPResponseHeaders();
        this.printSince((Doc)this.method.getJavaDoc());
        this.printSeeAlso((Doc)this.method.getJavaDoc());
        this.close("dl");
    }

    private void printIncludes() {
        MethodDoc javaDoc = this.method.getJavaDoc();
        Tag[] includes = Utils.getTags((Doc)javaDoc, "include");
        if (includes == null) {
            return;
        }
        File relativeTo = javaDoc.containingClass().position().file().getParentFile();
        for (Tag include : includes) {
            String fileName = include.text();
            File file = new File(relativeTo, fileName);
            if (!file.exists()) {
                this.doclet.printError(include.position(), "Missing included file: " + fileName);
                continue;
            }
            String text = Utils.readResource(file);
            this.print(text);
        }
    }

    private void printTaglets(String tagletName) {
        MethodDoc javaDoc = this.method.getJavaDoc();
        TagletOutputImpl output = new TagletOutputImpl("");
        HashSet<String> tagletsSet = new HashSet<String>();
        tagletsSet.add(tagletName);
        Utils.genTagOuput(this.configuration.parentConfiguration.tagletManager, (Doc)javaDoc, this.configuration.parentConfiguration.tagletManager.getCustomTags((Doc)javaDoc), this.writer.getTagletWriterInstance(false), (TagletOutput)output, tagletsSet);
        this.writer.print(output.toString());
    }

    private void printHTTPRequestHeaders() {
        this.printTaglets("ResponseHeader");
    }

    private void printHTTPResponseHeaders() {
        this.printTaglets("RequestHeader");
    }

    private void printHTTPCodes() {
        this.printTaglets("HTTP");
    }

    private void printOutput(PojoTypes types) {
        this.open("dt");
        this.around("b", "Output:");
        this.close("dt");
        MethodOutput output = this.method.getOutput();
        if (output.isOutputWrapped()) {
            for (int i = 0; i < output.getOutputWrappedCount(); ++i) {
                this.open("dd");
                String typeName = output.getWrappedOutputType(i);
                Utils.JaxType returnType = null;
                try {
                    returnType = Utils.parseType(typeName, this.method.getJavaDoc().containingClass(), this.doclet);
                }
                catch (Utils.InvalidJaxTypeException e) {
                    this.doclet.warn("Invalid @returnWrapped type: " + typeName);
                    e.printStackTrace();
                }
                if (returnType != null) {
                    this.printOutputType(returnType, types);
                } else {
                    this.around("tt", this.escape(typeName));
                }
                if (output.getOutputDoc(i) != null) {
                    this.print(" - ");
                    this.print(output.getOutputDoc(i));
                }
                this.close("dd");
            }
        } else {
            this.open("dd");
            Type returnType = output.getOutputType();
            this.printOutputType(returnType, types);
            if (output.getOutputDoc() != null) {
                this.print(" - ");
                this.print(output.getOutputDoc());
            }
            this.close("dd");
        }
    }

    private void printOutputType(Utils.JaxType type, PojoTypes types) {
        if (type.getType() == null) {
            this.doclet.warn("Type information not found: " + type.getTypeName());
            this.print(type.getTypeName());
            return;
        }
        this.open("tt");
        this.printOutputGenericType(type.getType(), types);
        if (type.hasParameters()) {
            boolean first = true;
            this.print("&lt;");
            for (Utils.JaxType genericType : type.getParameters()) {
                if (first) {
                    first = false;
                } else {
                    this.print(",");
                }
                this.printOutputGenericType(genericType.getType(), types);
            }
            this.print("&gt;");
        }
        this.close("tt");
    }

    private void printOutputType(Type type, PojoTypes types) {
        this.open("tt");
        this.printOutputGenericType(type, types);
        this.close("tt");
    }

    private void printOutputGenericType(Type type, PojoTypes types) {
        String link = null;
        if (!type.isPrimitive() && (link = Utils.getExternalLink((Configuration)this.configuration.parentConfiguration, type, this.writer)) == null && this.getJAXRSConfiguration().enablePojoJsonDataObjects && types.resolveUsedType(type)) {
            link = Utils.urlToRoot(this.getResource()) + DataObjectIndexWriter.getLink(type.asClassDoc());
        }
        if (link == null) {
            this.around("span title='" + type.qualifiedTypeName() + "'", type.simpleTypeName());
        } else {
            this.around("a title='" + type.qualifiedTypeName() + "' + href='" + link + "'", type.simpleTypeName());
        }
        ParameterizedType pType = type.asParameterizedType();
        if (pType != null) {
            boolean first = true;
            this.print("&lt;");
            for (Type genericType : pType.typeArguments()) {
                if (first) {
                    first = false;
                } else {
                    this.print(",");
                }
                this.printOutputGenericType(genericType, types);
            }
            this.print("&gt;");
        }
        this.print(type.dimension());
    }

    private void printInput(PojoTypes types) {
        MethodParameter inputParameter = this.method.getInputParameter();
        if (inputParameter == null) {
            return;
        }
        this.open("dt");
        this.around("b", "Input:");
        this.close("dt");
        if (inputParameter.isWrapped()) {
            this.open("dd");
            String typeName = inputParameter.getWrappedType();
            Utils.JaxType returnType = null;
            try {
                returnType = Utils.parseType(typeName, this.method.getJavaDoc().containingClass(), this.doclet);
            }
            catch (Utils.InvalidJaxTypeException e) {
                this.doclet.warn("Invalid @returnWrapped type: " + typeName);
                e.printStackTrace();
            }
            if (returnType != null) {
                this.printOutputType(returnType, types);
            } else {
                this.around("tt", this.escape(typeName));
            }
        } else {
            this.open("dd");
            Type returnType = inputParameter.getType();
            this.printOutputType(returnType, types);
        }
        String doc = inputParameter.getDoc();
        if (!Utils.isEmptyOrNull(doc)) {
            this.print(" - ");
            this.print(doc);
        }
        this.close("dd");
    }

    private void printParameters(List<MethodParameter> parameters, String header) {
        if (parameters.isEmpty()) {
            return;
        }
        this.open("dt");
        this.around("b", header + " parameters:");
        this.close("dt");
        for (MethodParameter param : parameters) {
            this.open("dd");
            this.around("b", param.getName());
            String doc = param.getDoc();
            if (!Utils.isEmptyOrNull(doc)) {
                this.print(" - " + param.getDoc());
            }
            this.close("dd");
        }
    }

    private void printMIMEs(List<String> mimes, String header) {
        if (!mimes.isEmpty()) {
            this.open("dt");
            this.around("b", header + ":");
            this.close("dt");
            for (String mime : mimes) {
                this.open("dd");
                this.print(mime);
                this.close("dd");
            }
        }
    }

    private void printAPIExample() {
        this.around("dt", "API Example:");
        this.open("dd");
        this.open("p");
        this.open("tt");
        this.print(this.method.getAPIFunctionName());
        this.print("({");
        boolean hasOne = this.printAPIParameters(this.method.getMatrixParameters(), false);
        hasOne |= this.printAPIParameters(this.method.getQueryParameters(), hasOne);
        hasOne |= this.printAPIParameters(this.method.getPathParameters(), hasOne);
        hasOne |= this.printAPIParameters(this.method.getHeaderParameters(), hasOne);
        hasOne |= this.printAPIParameters(this.method.getCookieParameters(), hasOne);
        hasOne |= this.printAPIParameters(this.method.getFormParameters(), hasOne);
        MethodParameter input = this.method.getInputParameter();
        if (input != null) {
            this.printAPIParameter("$entity", input, hasOne);
        }
        this.print("});");
        this.close("tt");
        this.close("p");
        this.close("dd");
    }

    private boolean printAPIParameters(List<MethodParameter> parameters, boolean hasOne) {
        for (MethodParameter parameter : parameters) {
            this.printAPIParameter(parameter.getName(), parameter, hasOne);
            hasOne = true;
        }
        return hasOne;
    }

    private void printAPIParameter(String name, MethodParameter param, boolean hasOne) {
        if (hasOne) {
            this.print(",");
            this.tag("br");
            this.print("&nbsp;&nbsp;");
        }
        hasOne = true;
        this.print("'" + name + "': ");
        Tag[] tags = param.getFirstSentenceTags();
        if (tags != null && tags.length > 0) {
            this.open("span class='comment'");
            this.print("/* ");
            this.writer.printSummaryComment(param.getParameterDoc(), tags);
            this.print(" */");
            this.close("span");
        } else {
            this.print("\u2026");
        }
    }

    private void printHTTPExample(String httpMethod) {
        List<MethodParameter> cookieParameters;
        List<MethodParameter> headerParameters;
        List<MethodParameter> queryParameters;
        this.around("dt", "HTTP Example:");
        this.open("dd");
        this.open("pre");
        String absPath = Utils.getAbsolutePath(this, this.resource);
        this.print(httpMethod + " " + absPath);
        List<MethodParameter> matrixParameters = this.method.getMatrixParameters();
        if (!matrixParameters.isEmpty()) {
            for (MethodParameter parameter : matrixParameters) {
                this.print(";");
                this.print(parameter.getName());
                this.print("=\u2026");
            }
        }
        if (!(queryParameters = this.method.getQueryParameters()).isEmpty()) {
            boolean first = true;
            for (MethodParameter parameter : queryParameters) {
                if (first) {
                    this.print("?");
                } else {
                    this.print("&amp;");
                }
                this.print(parameter.getName());
                this.print("=\u2026");
                first = false;
            }
        }
        if (!(headerParameters = this.method.getHeaderParameters()).isEmpty()) {
            this.print("\n");
            Iterator<MethodParameter> params = headerParameters.iterator();
            while (params.hasNext()) {
                MethodParameter parameter;
                parameter = params.next();
                this.print(parameter.getName());
                this.print(": \u2026");
                if (!params.hasNext()) continue;
                this.print("\n");
            }
        }
        if (!(cookieParameters = this.method.getCookieParameters()).isEmpty()) {
            this.print("\n");
            Iterator<MethodParameter> params = headerParameters.iterator();
            while (params.hasNext()) {
                MethodParameter parameter = params.next();
                this.print("Cookie: ");
                this.print(parameter.getName());
                this.print(": \u2026");
                if (!params.hasNext()) continue;
                this.print("\n");
            }
        }
        if (!this.method.getFormParameters().isEmpty()) {
            boolean first = true;
            for (MethodParameter parameter : this.method.getFormParameters()) {
                if (first) {
                    this.print("\n");
                } else {
                    this.print("&amp;");
                }
                this.print(parameter.getName());
                this.print("=\u2026");
                first = false;
            }
        }
        this.close("pre");
        this.close("dd");
    }
}

