/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxrs.writers;

import com.lunatech.doclets.jax.JAXConfiguration;
import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxrs.JAXRSDoclet;
import com.lunatech.doclets.jax.jaxrs.model.JAXRSApplication;
import com.lunatech.doclets.jax.jaxrs.model.PojoTypes;
import com.lunatech.doclets.jax.jaxrs.model.Resource;
import com.lunatech.doclets.jax.jaxrs.writers.DocletWriter;
import com.lunatech.doclets.jax.jaxrs.writers.JAXRSHtmlDocletWriter;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PojoClassWriter
extends DocletWriter {
    public static final String ZERO_OR_N = "zero or N[";
    private final ClassDoc cDoc;
    private final PojoTypes pojoTypes;
    private final PropertyDoc[] properties;

    public PojoClassWriter(JAXConfiguration configuration, JAXRSApplication application, ClassDoc cDoc, PojoTypes types, Resource resource, JAXRSDoclet doclet) {
        super(configuration, PojoClassWriter.getWriter(configuration, application, cDoc), application, resource, doclet);
        this.cDoc = cDoc;
        this.pojoTypes = types;
        this.properties = PojoClassWriter.getProperties(cDoc);
    }

    private static HtmlDocletWriter getWriter(JAXConfiguration configuration, JAXRSApplication application, ClassDoc cDoc) {
        try {
            return new JAXRSHtmlDocletWriter(application, configuration, Utils.classToPath(cDoc), cDoc.typeName() + ".html", Utils.classToRoot(cDoc));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write() {
        String objectType = this.cDoc.isEnum() ? "Enumeration" : "Data object";
        this.printPrelude(objectType + ": " + this.cDoc.typeName(), "");
        this.printSummary();
        this.printElements();
        this.tag("hr");
        this.printPostlude("");
        this.writer.flush();
        this.writer.close();
    }

    private void printElements() {
        if (this.cDoc.isEnum()) {
            this.printEnumConstants();
        } else {
            this.printProperties(this.properties, "Properties");
        }
    }

    private void printSummary() {
        ClassDoc javaDoc;
        List<ClassDoc> subClasses;
        this.open("h2 class='pojosummary'");
        String objectType = this.cDoc.isEnum() ? "Enumeration" : "Data object";
        this.around("span class='name'", objectType + ": " + this.cDoc.simpleTypeName());
        this.around("span class='namespace'", "(in " + this.getContainer() + ")");
        this.close("h2");
        ClassDoc superClass = this.cDoc.superclass();
        if (this.pojoTypes.getResolvedTypes().contains(superClass)) {
            this.open("dl class='supertype'");
            this.around("dt", "Supertype:");
            this.open("dd");
            this.around("a title='" + superClass.qualifiedTypeName() + "' href='" + Utils.urlToClass(this.cDoc, superClass) + "'", superClass.simpleTypeName());
            this.close("dd", "dl");
        }
        if (!(subClasses = this.pojoTypes.getSubclasses(this.cDoc)).isEmpty()) {
            this.open("dl class='subtypes'");
            this.around("dt", "Known sub-types:");
            this.open("dd");
            for (int i = 0; i < subClasses.size(); ++i) {
                ClassDoc scDoc = subClasses.get(i);
                this.around("a title='" + scDoc.qualifiedTypeName() + "' href='" + Utils.urlToClass(this.cDoc, scDoc) + "'", scDoc.simpleTypeName());
                if (i >= subClasses.size() - 1) continue;
                this.print(",");
            }
            this.close("dd", "dl");
        }
        if ((javaDoc = this.cDoc).tags() != null) {
            this.writer.printInlineComment((Doc)javaDoc);
        }
        this.printSince((Doc)javaDoc);
        this.printSeeAlso((Doc)javaDoc);
    }

    private String getContainer() {
        return this.cDoc.containingClass() == null ? this.cDoc.containingPackage().name() : this.cDoc.containingClass().qualifiedTypeName();
    }

    private static PropertyDoc[] getProperties(ClassDoc classDoc) {
        ArrayList<PropertyDoc> properties = new ArrayList<PropertyDoc>();
        for (MethodDoc method : classDoc.methods()) {
            if (!PojoClassWriter.isDocumentableProperty(method)) continue;
            PropertyDoc prop = new PropertyDoc(PojoClassWriter.getPropertyName(method.name()), method.returnType(), (MemberDoc)method);
            properties.add(prop);
        }
        Object[] props = properties.toArray(new PropertyDoc[properties.size()]);
        Arrays.sort(props);
        return props;
    }

    private static boolean isDocumentableProperty(MethodDoc method) {
        if (method.name().startsWith("get") || method.name().startsWith("is") && method.returnType().simpleTypeName().equalsIgnoreCase("boolean")) {
            AnnotationDesc jsonIgnore = Utils.findAnnotation(method.annotations(), "org.codehaus.jackson.annotate.JsonIgnore", "com.fasterxml.jackson.annotation.JsonIgnore");
            if (jsonIgnore == null || Boolean.FALSE.equals(Utils.getAnnotationValue(jsonIgnore))) {
                return true;
            }
            System.err.println(method.qualifiedName() + " is @JsonIgnored");
        }
        return false;
    }

    private static String getPropertyName(String memberName) {
        String basename = null;
        if (memberName.startsWith("is")) {
            basename = memberName.substring("is".length());
        } else if (memberName.startsWith("get")) {
            basename = memberName.substring("get".length());
        }
        if (basename != null) {
            return Character.toLowerCase(basename.charAt(0)) + basename.substring(1);
        }
        return memberName;
    }

    private void printEnumConstants() {
        this.tag("hr");
        this.open("table class='info' id='EnumConstants'");
        this.around("caption class='TableCaption'", "Enum Constants");
        this.open("tbody");
        this.open("tr");
        this.around("th class='TableHeader'", "Constant");
        this.around("th class='TableHeader DescriptionHeader'", "Description");
        this.close("tr");
        for (FieldDoc enumConst : this.cDoc.enumConstants()) {
            this.open("tr");
            this.open("td id='ec_" + enumConst.name() + "'");
            this.print(enumConst.name());
            this.close("td");
            this.open("td");
            FieldDoc javaDoc = enumConst;
            if (!Utils.isEmptyOrNull(javaDoc.commentText())) {
                this.writer.printInlineComment((Doc)javaDoc);
            }
            this.close("td");
            this.close("tr");
        }
        this.close("tbody");
        this.close("table");
    }

    private void printProperties(PropertyDoc[] propertyDocs, String title) {
        this.tag("hr");
        this.open("table class='info' id='" + title + "'");
        this.around("caption class='TableCaption'", title);
        this.open("tbody");
        this.open("tr");
        this.around("th class='TableHeader'", "Name");
        this.around("th class='TableHeader'", "Type");
        this.around("th class='TableHeader DescriptionHeader'", "Description");
        this.close("tr");
        for (PropertyDoc member : propertyDocs) {
            this.open("tr");
            this.open("td id='m_" + member.getName() + "'");
            this.print(member.getName());
            this.close("td");
            this.open("td");
            this.printMemberType(member);
            this.close("td");
            this.open("td");
            MemberDoc javaDoc = member.getMemberDoc();
            if (!Utils.isEmptyOrNull(javaDoc.commentText())) {
                this.writer.printInlineComment((Doc)javaDoc);
            }
            this.close("td");
            this.close("tr");
        }
        this.close("tbody");
        this.close("table");
    }

    private void printMemberType(PropertyDoc prop) {
        this.open("tt");
        Type type = prop.getType();
        this.printMemberTypeGeneric(type);
        this.close("tt");
    }

    private void printMemberTypeGeneric(Type type) {
        if (type.isPrimitive() || type.qualifiedTypeName().startsWith("java.lang")) {
            this.print(type.simpleTypeName());
        } else {
            ClassDoc fDoc = type.asClassDoc();
            if (fDoc == null || fDoc.qualifiedName().equals(this.cDoc.qualifiedName()) || !this.pojoTypes.getResolvedTypes().contains(fDoc)) {
                this.around("span title='" + type.qualifiedTypeName() + "'", type.simpleTypeName());
            } else {
                this.around("a title='" + fDoc.qualifiedTypeName() + "' href='" + Utils.urlToClass(this.cDoc, fDoc) + "'", fDoc.simpleTypeName());
            }
        }
        ParameterizedType pType = type.asParameterizedType();
        if (pType != null) {
            boolean first = true;
            this.print("&lt;");
            for (Type genericType : pType.typeArguments()) {
                if (first) {
                    first = false;
                } else {
                    this.print(",");
                }
                this.printMemberTypeGeneric(genericType);
            }
            this.print("&gt;");
        }
        this.print(type.dimension());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyDoc
    implements Comparable<PropertyDoc> {
        private final String name;
        private final Type type;
        private final MemberDoc memberDoc;

        public PropertyDoc(String name, Type type, MemberDoc memberDoc) {
            this.name = name;
            this.type = type;
            this.memberDoc = memberDoc;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public MemberDoc getMemberDoc() {
            return this.memberDoc;
        }

        @Override
        public int compareTo(PropertyDoc o) {
            return this.name.compareTo(o.name);
        }
    }
}

