/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jpa.model;

import com.lunatech.doclets.jax.JAXConfiguration;
import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jpa.JPADoclet;
import com.lunatech.doclets.jax.jpa.model.Column;
import com.lunatech.doclets.jax.jpa.model.JPAMember;
import com.lunatech.doclets.jax.jpa.model.Registry;
import com.lunatech.doclets.jax.jpa.model.Relation;
import com.lunatech.doclets.jax.jpa.writers.JPAClassWriter;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAClass
implements Comparable<JPAClass> {
    private Set<Column> columns = new TreeSet<Column>();
    private Set<Relation> relations = new TreeSet<Relation>();
    private ClassDoc klass;
    private String name;
    private Registry registry;
    private JPADoclet doclet;
    private Map<String, JPAMember> members = new HashMap<String, JPAMember>();

    public JPAClass(ClassDoc klass, Registry registry, JPADoclet doclet) {
        this.klass = klass;
        this.registry = registry;
        this.doclet = doclet;
        AnnotationDesc tableAnnotation = Utils.findAnnotation((ProgramElementDoc)klass, Table.class);
        if (tableAnnotation != null) {
            this.name = (String)Utils.getAnnotationValue(tableAnnotation, "name");
        }
        if (this.name == null) {
            this.name = klass.simpleTypeName();
        }
        this.setupMembers(klass, this.isIDOnField(klass));
    }

    private boolean isIDOnField(ClassDoc klass) {
        for (FieldDoc fieldDoc : klass.fields(false)) {
            if (Utils.findAnnotation((ProgramElementDoc)fieldDoc, Id.class) == null) continue;
            return true;
        }
        for (FieldDoc fieldDoc : klass.methods(false)) {
            if (Utils.findAnnotation((ProgramElementDoc)fieldDoc, Id.class) == null) continue;
            return false;
        }
        ClassDoc superClass = klass.superclass();
        if (superClass != null && !superClass.qualifiedTypeName().startsWith("java.")) {
            return this.isIDOnField(superClass);
        }
        return true;
    }

    private void setupMembers(ClassDoc klass, boolean isIDOnField) {
        for (FieldDoc fieldDoc : klass.fields(false)) {
            this.addProperty((ProgramElementDoc)fieldDoc, isIDOnField);
        }
        for (FieldDoc fieldDoc : klass.methods(false)) {
            this.addProperty((ProgramElementDoc)fieldDoc, !isIDOnField);
        }
        ClassDoc superClass = klass.superclass();
        if (superClass != null && !superClass.qualifiedTypeName().startsWith("java.")) {
            this.setupMembers(superClass, isIDOnField);
        }
    }

    private void addProperty(ProgramElementDoc property, boolean includeByDefault) {
        boolean include;
        boolean isTransient;
        if (property.isMethod() && !this.isProperty((MethodDoc)property)) {
            return;
        }
        if (property.isStatic()) {
            return;
        }
        AnnotationDesc columnAnnotation = Utils.findAnnotation(property, javax.persistence.Column.class);
        if (columnAnnotation == null) {
            columnAnnotation = Utils.findAnnotation(property, JoinColumn.class);
        }
        AnnotationDesc transientAnnotation = Utils.findAnnotation(property, Transient.class);
        boolean hasJPAAnnotation = columnAnnotation != null;
        boolean bl = isTransient = transientAnnotation != null;
        if (property.isField()) {
            isTransient |= ((FieldDoc)property).isTransient();
        }
        boolean bl2 = include = !isTransient && (includeByDefault || hasJPAAnnotation);
        if (include) {
            this.addElement(property, columnAnnotation);
        }
    }

    private boolean isProperty(MethodDoc method) {
        String name = method.name();
        if (method.parameters().length != 0) {
            return false;
        }
        if (name.startsWith("get")) {
            return name.length() > 3;
        }
        if (name.startsWith("is") && method.returnType().toString().equals("boolean")) {
            return name.length() > 2;
        }
        return false;
    }

    private void addElement(ProgramElementDoc property, AnnotationDesc columnAnnotation) {
        String name = property.name();
        if (property.isMethod()) {
            name = name.startsWith("get") ? name.substring(3) : name.substring(2);
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        if (!this.members.containsKey(name)) {
            this.addElement(property, name, columnAnnotation);
        }
    }

    private void addElement(ProgramElementDoc property, String name, AnnotationDesc columnAnnotation) {
        AnnotationDesc relation = Utils.findAnnotation(property, OneToMany.class, ManyToOne.class, OneToOne.class, ManyToMany.class);
        if (relation == null) {
            this.addColumn(property, name, columnAnnotation);
        } else {
            this.addRelation(property, name, columnAnnotation, relation);
        }
    }

    private void addRelation(ProgramElementDoc property, String propertyName, AnnotationDesc columnAnnotation, AnnotationDesc relation) {
        String overriddenName;
        String name = propertyName;
        if (columnAnnotation != null && (overriddenName = (String)Utils.getAnnotationValue(columnAnnotation, "name")) != null) {
            name = overriddenName;
        }
        Relation element = new Relation(this, property, name, columnAnnotation, relation);
        this.members.put(propertyName, element);
        this.relations.add(element);
    }

    private void addColumn(ProgramElementDoc property, String propertyName, AnnotationDesc columnAnnotation) {
        String overriddenName;
        String name = propertyName;
        if (columnAnnotation != null && (overriddenName = (String)Utils.getAnnotationValue(columnAnnotation, "name")) != null) {
            name = overriddenName;
        }
        Column element = new Column(this, property, name, columnAnnotation);
        this.members.put(propertyName, element);
        this.columns.add(element);
    }

    public String getQualifiedClassName() {
        return this.klass.qualifiedName();
    }

    public JPADoclet getDoclet() {
        return this.doclet;
    }

    public String getName() {
        return this.name;
    }

    public void write(JAXConfiguration configuration) {
        new JPAClassWriter(configuration, this).write();
    }

    public Doc getJavaDoc() {
        return this.klass;
    }

    public Collection<Column> getColumns() {
        return this.columns;
    }

    public Collection<Relation> getRelations() {
        return this.relations;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public String getPackageName() {
        return this.klass.containingPackage().name();
    }

    public String getShortClassName() {
        return this.klass.name();
    }

    @Override
    public int compareTo(JPAClass other) {
        return this.name.compareToIgnoreCase(other.name);
    }

    public List<JPAMember> getMembers() {
        ArrayList<JPAMember> list = new ArrayList<JPAMember>(this.columns.size());
        list.addAll(this.columns);
        list.addAll(this.relations);
        return list;
    }

    public JPAMember getID() {
        return null;
    }

    public Relation getRelation(String name) {
        JPAMember member = this.members.get(name);
        if (member instanceof Relation) {
            return (Relation)member;
        }
        return null;
    }
}

