/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jpa.writers;

import com.lunatech.doclets.jax.JAXConfiguration;
import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jpa.model.JPAClass;
import com.lunatech.doclets.jax.jpa.model.Registry;
import com.lunatech.doclets.jax.jpa.model.Relation;
import com.lunatech.doclets.jax.writers.DocletWriter;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import java.io.IOException;

public class GraphDataWriter
extends DocletWriter {
    private Registry registry;

    public GraphDataWriter(JAXConfiguration configuration, Registry registry) {
        super(configuration, GraphDataWriter.getWriter(configuration));
        this.registry = registry;
    }

    private static HtmlDocletWriter getWriter(JAXConfiguration configuration) {
        try {
            return new HtmlDocletWriter(configuration.parentConfiguration, "", "graph-data.js", "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write() {
        this.print("var json = [\n");
        boolean doComma = false;
        for (JPAClass klass : this.registry.getJPAClasses()) {
            if (doComma) {
                this.print(" ,\n");
            }
            doComma = true;
            String url = this.writer.relativePath + Utils.classToPath(klass) + "/" + klass.getShortClassName() + ".html";
            this.print(" {\n");
            this.print("  name: '" + klass.getName() + "',\n");
            this.print("  id: '" + klass.getName() + "',\n");
            this.print("  data: {\n");
            this.print("   $url: '" + url + "'\n");
            this.print("  },\n");
            this.print("  adjacencies: [\n");
            boolean doComma2 = false;
            for (Relation relation : klass.getRelations()) {
                if (doComma2) {
                    this.print("   ,\n");
                }
                doComma2 = true;
                String name = relation.getJavaTypeName();
                JPAClass typeClass = this.registry.getJPAClass(name);
                this.print("   {\n");
                this.print("    nodeTo: '" + typeClass.getName() + "',\n");
                this.print("    data: {\n");
                this.print("     $labeltext: '" + (Object)((Object)relation.getRelationFrom()) + ".." + (Object)((Object)relation.getRelationTo()) + "',\n");
                this.print("     $type: 'fooType'\n");
                this.print("    }\n");
                this.print("   }\n");
            }
            this.print("  ]\n");
            this.print(" }\n");
        }
        this.print("];\n");
        this.writer.flush();
        this.writer.close();
    }
}

