/*
 * Decompiled with CFR 0.152.
 */
package com.mailjet.client.easy;

import com.mailjet.client.MailjetRequest;
import com.mailjet.client.MailjetResponse;
import com.mailjet.client.easy.MJEasyClient;
import com.mailjet.client.errors.MailjetException;
import com.mailjet.client.errors.MailjetSocketTimeoutException;
import com.mailjet.client.resource.Contact;
import com.mailjet.client.resource.Email;
import org.json.JSONArray;
import org.json.JSONObject;

public class MJEasyEmail {
    private final MJEasyClient client;
    private final MailjetRequest request;
    private final JSONArray recipients = new JSONArray();

    protected MJEasyEmail(MJEasyClient client, MailjetRequest request) {
        this.client = client;
        this.request = request;
    }

    public MJEasyEmail from(String email, String name) {
        this.request.property(Email.FROMEMAIL, email);
        if (name != null) {
            this.request.property(Email.FROMNAME, name);
        }
        return this;
    }

    public MJEasyEmail from(String email) {
        return this.from(email, null);
    }

    public MJEasyEmail to(String email) {
        this.recipients.put((Object)new JSONObject().put(Contact.EMAIL, (Object)email));
        this.request.property(Email.RECIPIENTS, this.recipients);
        return this;
    }

    public MJEasyEmail subject(String subject) {
        this.request.property(Email.SUBJECT, subject);
        return this;
    }

    public MJEasyEmail text(String text) {
        this.request.property(Email.TEXTPART, text);
        return this;
    }

    public MJEasyEmail html(String html) {
        this.request.property(Email.HTMLPART, html);
        return this;
    }

    public MJEasyEmail customId(String customId) {
        this.request.property(Email.MJCUSTOMID, customId);
        return this;
    }

    public MailjetResponse send() throws MailjetException, MailjetSocketTimeoutException {
        return this.client.getClient().post(this.request);
    }

    public MailjetRequest getRequest() {
        return this.request;
    }
}

