/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.agent;

import com.microsoft.applicationinsights.agent.internal.sdk.SdkBridge;
import com.microsoft.applicationinsights.core.dependencies.javaxannotation.Nullable;
import com.microsoft.applicationinsights.internal.agent.AgentBinding;
import com.microsoft.applicationinsights.internal.agent.AgentBridge;
import com.microsoft.applicationinsights.internal.agent.AgentBridgeImpl;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;

public class AgentBridgeFactory {
    public static boolean isAgentAvailable() {
        try {
            Class.forName("com.microsoft.applicationinsights.agent.internal.sdk.AgentBridgeInternal", false, null);
            return true;
        }
        catch (ClassNotFoundException e) {
            InternalLogger.INSTANCE.trace("agent not found", new Object[0]);
            return false;
        }
    }

    public static <T> AgentBridge<T> create() {
        return new NopAgentBridge();
    }

    public static <T> AgentBridge<T> create(SdkBridgeFactory<T> sdkBridgeFactory) {
        return new AgentBridgeImpl<T>(sdkBridgeFactory.create());
    }

    private static class NopAgentBinding
    implements AgentBinding {
        private static final AgentBinding INSTANCE = new NopAgentBinding();

        private NopAgentBinding() {
        }

        @Override
        public void unbindFromMainThread() {
        }

        @Override
        public void unbindFromRunawayChildThreads() {
        }
    }

    private static class NopAgentBridge<T>
    implements AgentBridge<T> {
        private NopAgentBridge() {
        }

        @Override
        public boolean isAgentRunning() {
            return false;
        }

        @Override
        public AgentBinding bindToThread(T requestTelemetryContext, @Nullable AgentBridge.ServletRequestInfo servletRequestInfo) {
            return NopAgentBinding.INSTANCE;
        }
    }

    public static interface SdkBridgeFactory<T> {
        public SdkBridge<T> create();
    }
}

