/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.heartbeat;

import com.microsoft.applicationinsights.internal.heartbeat.DefaultHeartBeatPropertyProvider;
import com.microsoft.applicationinsights.internal.heartbeat.HeartBeatPayloadProviderInterface;
import com.microsoft.applicationinsights.internal.heartbeat.HeartBeatProviderInterface;
import com.microsoft.applicationinsights.internal.heartbeat.WebAppsHeartbeatProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class HeartbeatDefaultPayload {
    private static final List<HeartBeatPayloadProviderInterface> defaultPayloadProviders = new ArrayList<HeartBeatPayloadProviderInterface>();

    public static boolean isDefaultKeyword(String keyword) {
        for (HeartBeatPayloadProviderInterface payloadProvider : defaultPayloadProviders) {
            if (!payloadProvider.isKeyword(keyword)) continue;
            return true;
        }
        return false;
    }

    public static boolean addDefaultPayLoadProvider(HeartBeatPayloadProviderInterface payloadProviderInterface) {
        if (payloadProviderInterface != null) {
            defaultPayloadProviders.add(payloadProviderInterface);
            return true;
        }
        return false;
    }

    public static Callable<Boolean> populateDefaultPayload(final List<String> disabledFields, final List<String> disabledProviders, final HeartBeatProviderInterface provider) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean populatedFields = false;
                for (HeartBeatPayloadProviderInterface payloadProvider : defaultPayloadProviders) {
                    if (disabledProviders != null && disabledProviders.contains(payloadProvider.getName())) continue;
                    boolean fieldsAreSet = payloadProvider.setDefaultPayload(disabledFields, provider).call();
                    populatedFields = populatedFields || fieldsAreSet;
                }
                return populatedFields;
            }
        };
    }

    static {
        defaultPayloadProviders.add(new DefaultHeartBeatPropertyProvider());
        defaultPayloadProviders.add(new WebAppsHeartbeatProvider());
    }
}

