/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.microsoft.applicationinsights.internal.schemav2.RequestData;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.telemetry.BaseTelemetry;
import com.microsoft.applicationinsights.telemetry.Duration;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public final class RequestTelemetry
extends BaseTelemetry {
    private final RequestData data = new RequestData();

    public RequestTelemetry(String name, Date timestamp, Duration duration, String responseCode, boolean success) {
        this.initialize(this.data.getProperties());
        this.setId(LocalStringsUtils.generateRandomIntegerId());
        this.setTimestamp(timestamp);
        this.setName(name);
        this.setDuration(duration);
        this.setResponseCode(responseCode);
        this.setSuccess(success);
    }

    public RequestTelemetry(String name, Date timestamp, long duration, String responseCode, boolean success) {
        this(name, timestamp, new Duration(duration), responseCode, success);
    }

    public RequestTelemetry() {
        this.initialize(this.data.getProperties());
        this.setId(LocalStringsUtils.generateRandomIntegerId());
        this.setTimestamp(new Date());
        this.setResponseCode("200");
        this.setSuccess(true);
    }

    @Override
    public void setTimestamp(Date timestamp) {
        if (timestamp == null) {
            timestamp = new Date();
        }
        super.setTimestamp(timestamp);
    }

    public String getName() {
        return this.data.getName();
    }

    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The event name cannot be null or empty");
        }
        this.data.setName(name);
    }

    public String getId() {
        return this.data.getId();
    }

    public void setId(String id) {
        this.data.setId(id);
    }

    public String getResponseCode() {
        return this.data.getResponseCode();
    }

    public void setResponseCode(String responseCode) {
        this.data.setResponseCode(responseCode);
    }

    public String getSource() {
        return this.data.getSource();
    }

    public void setSource(String value) {
        this.data.setSource(value);
    }

    public boolean isSuccess() {
        return this.data.getSuccess();
    }

    public void setSuccess(boolean success) {
        this.data.setSuccess(success);
    }

    public Duration getDuration() {
        return this.data.getDuration();
    }

    public void setDuration(Duration duration) {
        this.data.setDuration(duration);
    }

    @Nullable
    public URL getUrl() throws MalformedURLException {
        String url = this.data.getUrl();
        if (LocalStringsUtils.isNullOrEmpty(url)) {
            return null;
        }
        return new URL(url);
    }

    public void setUrl(URL url) {
        this.data.setUrl(url.toString());
    }

    public void setUrl(String url) throws MalformedURLException {
        URL u = new URL(url);
        this.data.setUrl(u.toString());
    }

    public ConcurrentMap<String, Double> getMetrics() {
        return this.data.getMeasurements();
    }

    @Override
    protected RequestData getData() {
        return this.data;
    }
}

